package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Images;
import com.flybits.concierge.viewpopulators.ImagesViewPopulator;

public class ImageViewHolder extends FlybitsViewHolder<Images>
{
    private View thisView;
    private ImageView singleView;
    private View doubleView;
    private View multipleView;

    private ImageView[] doubleImages;
    private ImageView[] multipleImages;

    private Images currentBoundImage;

    private ImagesViewPopulator imagesViewPopulator;

    public ImageViewHolder(View itemView, ImagesViewPopulator imagesViewPopulator)
    {
        super(itemView);
        this.thisView = itemView;

        singleView = itemView.findViewById(R.id.flybits_con_item_image_imgSingle);

        doubleImages = new ImageView[] {
                itemView.findViewById(R.id.flybits_con_item_image_imgDoubleLeft),
                itemView.findViewById(R.id.flybits_con_item_image_imgDoubleRight)
        };

        multipleImages = new ImageView[] {
                itemView.findViewById(R.id.flybits_con_item_image_imgBig),
                itemView.findViewById(R.id.flybits_con_item_image_imgTR),
                itemView.findViewById(R.id.flybits_con_item_image_imgBR)
        };

        doubleView = itemView.findViewById(R.id.flybits_con_item_image_lytDouble);
        multipleView = itemView.findViewById(R.id.flybits_con_item_image_lytTriple);

        this.imagesViewPopulator = imagesViewPopulator;
    }

    @Override
    public void bindData(final Images images, FlybitsNavigator flybitsNavigator)
    {
        currentBoundImage = images;
        imagesViewPopulator.populate(images, flybitsNavigator, thisView, singleView
                , doubleView, multipleView, doubleImages, multipleImages, currentBoundImage);
    }
}
