package com.flybits.concierge.adapters

import android.arch.paging.PagedListAdapter
import android.support.v7.util.DiffUtil
import android.view.LayoutInflater
import android.view.ViewGroup

import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.FlybitsViewProviderGetter
import com.flybits.concierge.models.BaseTemplate
import com.flybits.concierge.viewholders.FlybitsViewHolder
import com.flybits.concierge.viewholders.UnknownViewHolder

class FeedAdapter(private val flybitsViewProviderGetter: FlybitsViewProviderGetter
                  , private val conFrag: ConciergeFragment)
    : PagedListAdapter<BaseTemplate, FlybitsViewHolder<BaseTemplate>>(ITEM_CALLBACK) {

    companion object {
        private val ITEM_CALLBACK = object : DiffUtil.ItemCallback<BaseTemplate>() {
            override fun areItemsTheSame(oldItem: BaseTemplate, newItem: BaseTemplate): Boolean {
                return oldItem.content.id == newItem.content.id
            }

            override fun areContentsTheSame(oldItem: BaseTemplate, newItem: BaseTemplate): Boolean {
                return oldItem.content == newItem.content
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): FlybitsViewHolder<BaseTemplate> {

        //Try to find flybits view provider with associated content type, if not found then use first provider in list
        val provider = flybitsViewProviderGetter.flybitsViewProviders
                ?.find { it.getContentType().hashCode() == viewType }

        return provider?.onCreateViewHolder(parent) ?: UnknownViewHolder(LayoutInflater.from(parent.context).inflate(android.R.layout.simple_list_item_1, parent, false))
    }

    override fun onBindViewHolder(holder: FlybitsViewHolder<BaseTemplate>, position: Int) {
        getItem(position)?.let{
            holder.bindData(it, conFrag)
        }
    }

    override fun getItemCount() = currentList?.size ?: 0

    override fun getItemViewType(position: Int) = getItem(position)?.content?.type?.hashCode() ?: 0

    override fun getItemId(position: Int) = getItem(position)?.content?.createdAt ?: 0
}
