/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProviders;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.viewmodels.VideoViewModel;

public class VideoFragment
extends Fragment {
    private static final String ARG_VIDEO = "flybits_con_arg_video";
    private static final String ARG_URL = "flybits_con_arg_url";
    private String title;
    private String url;
    private VideoViewModel viewModel;
    private VideoView videoView;

    public static VideoFragment newInstance(Video video) {
        VideoFragment fragment = new VideoFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_VIDEO, (Parcelable)video);
        fragment.setArguments(args);
        return fragment;
    }

    public static VideoFragment newInstance(String video) {
        VideoFragment fragment = new VideoFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, video);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            Video video = (Video)this.getArguments().getParcelable(ARG_VIDEO);
            if (video != null) {
                this.title = video.title.getValue();
                this.url = video.url;
            } else {
                this.title = this.getString(R.string.flybits_con_content_video);
                this.url = this.getArguments().getString(ARG_URL);
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_video, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.viewModel = (VideoViewModel)ViewModelProviders.of((Fragment)this).get(VideoViewModel.class);
        this.videoView = (VideoView)view.findViewById(R.id.flybits_con_fragment_video_viewVideo);
        TextView titleView = (TextView)view.findViewById(R.id.flybits_con_fragment_video_txtTitle);
        titleView.setText((CharSequence)this.title);
        MediaController mediaController = new MediaController(this.getContext());
        mediaController.setAnchorView((View)this.videoView);
        Uri videoUri = Uri.parse((String)this.url);
        this.videoView.setMediaController(mediaController);
        this.videoView.setVideoURI(videoUri);
        this.videoView.requestFocus();
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                VideoFragment.this.videoView.seekTo(VideoFragment.this.viewModel.getSeekPosition());
                VideoFragment.this.videoView.start();
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                new MaterialDialog.Builder((Context)VideoFragment.this.getActivity()).title(R.string.flybits_con_video_fragment_error_title).content(R.string.flybits_con_video_fragment_error_message).positiveText(R.string.flybits_con_ok).show();
                VideoFragment.this.getFragmentManager().popBackStack();
                return true;
            }
        });
    }

    public void onStop() {
        super.onStop();
        this.viewModel.setSeekPosition(this.videoView.getCurrentPosition());
    }
}

