/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.flybits.concierge.OnboardingListener;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.models.OnboardingPage;
import com.flybits.concierge.viewpopulators.OnboardingViewPopulator;
import com.google.android.material.tabs.TabLayout;

public class OnboardingFragment
extends Fragment
implements ViewPager.OnPageChangeListener {
    private static final String ARG_ONBOARDING = "flybits_con_on_boarding_arg";
    private Onboarding onboarding;
    private ViewPager pager;
    private Button skipButton;
    private OnboardingListener listener;
    private OnboardingViewPopulator onboardingViewPopulator;

    public static OnboardingFragment newInstance(Onboarding onboarding) {
        OnboardingFragment fragment = new OnboardingFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_ONBOARDING, (Parcelable)onboarding);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.onboarding = (Onboarding)this.getArguments().getParcelable(ARG_ONBOARDING);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_on_boarding, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.onboardingViewPopulator = new OnboardingViewPopulator();
        this.pager = (ViewPager)view.findViewById(R.id.flybits_con_fragment_on_boarding_viewPager);
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        OnboardingAdapter adapter = new OnboardingAdapter();
        this.pager.setAdapter((PagerAdapter)adapter);
        TabLayout tabLayout = (TabLayout)view.findViewById(R.id.flybits_con_fragment_on_boarding_tabLayout);
        tabLayout.setupWithViewPager(this.pager, true);
        this.skipButton = (Button)view.findViewById(R.id.flybits_con_fragment_on_boarding_btnFooter);
        this.skipButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OnboardingFragment.this.listener != null) {
                    int lastPage;
                    int page = OnboardingFragment.this.pager.getCurrentItem();
                    if (page == (lastPage = OnboardingFragment.this.pager.getAdapter().getCount() - 1)) {
                        OnboardingFragment.this.listener.onFinished();
                    } else {
                        OnboardingFragment.this.listener.onSkip();
                    }
                } else {
                    OnboardingFragment.this.getFragmentManager().popBackStack();
                }
            }
        });
        this.changeOnBoardingState();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.changeOnBoardingState();
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void setOnboardingListener(OnboardingListener listener) {
        this.listener = listener;
    }

    private void changeOnBoardingState() {
        int lastPage;
        int page = this.pager.getCurrentItem();
        if (page == (lastPage = this.pager.getAdapter().getCount() - 1)) {
            this.skipButton.setText(R.string.flybits_con_fragment_on_boarding_finish);
        } else {
            this.skipButton.setText(R.string.flybits_con_fragment_on_boarding_skip);
        }
    }

    public class OnboardingAdapter
    extends PagerAdapter {
        public int getCount() {
            return ((OnboardingFragment)OnboardingFragment.this).onboarding.onboardingPages.getList().size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            View view = OnboardingFragment.this.getLayoutInflater().inflate(R.layout.flybits_con_fragment_on_boarding_item, container, false);
            ImageView imageView = (ImageView)view.findViewById(R.id.flybits_con_fragment_on_boarding_item_imgLogo);
            TextView titleTextView = (TextView)view.findViewById(R.id.flybits_con_fragment_on_boarding_item_txtTitle);
            TextView bodyTextView = (TextView)view.findViewById(R.id.flybits_con_fragment_on_boarding_item_txtBody);
            OnboardingPage ob = (OnboardingPage)((OnboardingFragment)OnboardingFragment.this).onboarding.onboardingPages.getList().get(position);
            OnboardingFragment.this.onboardingViewPopulator.populate(ob, titleTextView, bodyTextView, imageView);
            container.addView(view);
            return view;
        }
    }
}

