/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.concierge.R;
import java.util.Locale;

public class ImageFragment
extends Fragment {
    private static final String ARG_IMAGEURI = "arg_uri";
    private static final String ARG_ISMORE = "arg_isMore";
    private static final String ARG_MORECOUNT = "arg_moreCount";
    private static final String ARG_CENTERCROP = "arg_centercrop";
    ImageView imgImage;
    LinearLayout lytMore;
    String imageUri;
    TextView txtMoreLabel;
    View.OnClickListener clickListener;
    boolean isMore = false;

    public static ImageFragment newInstance(String uri, boolean centerCrop, boolean isMore, int moreCount) {
        ImageFragment frag = new ImageFragment();
        Bundle args = new Bundle();
        args.putString(ARG_IMAGEURI, uri);
        args.putBoolean(ARG_CENTERCROP, centerCrop);
        args.putBoolean(ARG_ISMORE, isMore);
        args.putInt(ARG_MORECOUNT, moreCount);
        frag.setArguments(args);
        return frag;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.flybits_con_fragment_imageview, container, false);
        this.imgImage = (ImageView)v.findViewById(R.id.flybits_con_fragment_imageviewer_imgImage);
        this.lytMore = (LinearLayout)v.findViewById(R.id.flybits_con_fragment_imageviewer_lytMore);
        this.txtMoreLabel = (TextView)v.findViewById(R.id.flybits_con_fragment_imageviewer_txtMore);
        this.imgImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.imageUri = this.getArguments().getString(ARG_IMAGEURI);
        this.isMore = this.getArguments().getBoolean(ARG_ISMORE, false);
        this.imgImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ImageFragment.this.clickListener != null) {
                    ImageFragment.this.clickListener.onClick(view);
                }
            }
        });
        this.imgImage.setScaleType(this.getArguments().getBoolean(ARG_CENTERCROP, true) ? ImageView.ScaleType.CENTER_CROP : ImageView.ScaleType.FIT_CENTER);
        if (this.isMore) {
            this.lytMore.setVisibility(0);
            int moreCount = this.getArguments().getInt(ARG_MORECOUNT, -1);
            if (moreCount > 0) {
                this.txtMoreLabel.setText((CharSequence)String.format(Locale.getDefault(), "View %d more", moreCount));
            } else {
                this.txtMoreLabel.setText(R.string.flybits_con_fragment_image_view_more);
            }
        } else {
            this.lytMore.setVisibility(8);
        }
        return v;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        RequestOptions options = (RequestOptions)new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
        Glide.with((Context)view.getContext()).load(this.imageUri).apply((BaseRequestOptions)options).into(this.imgImage);
    }

    public void setImageOnClickListener(View.OnClickListener listener) {
        this.clickListener = listener;
    }
}

