/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.activities;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import com.flybits.concierge.R;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayerView;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerInitListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.playerUtils.FullScreenHelper;

public class YouTubePlayerActivity
extends AppCompatActivity {
    public static final String ARG_ID_KEY = "flybits_con_arg_youtubeid";
    private YouTubePlayerView youTubePlayerView;
    private FullScreenHelper fullScreenHelper = new FullScreenHelper();
    private String youtubeVideoId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.flybits_con_activity_you_tube_player);
        this.youTubePlayerView = (YouTubePlayerView)this.findViewById(R.id.flybits_con_activity_you_tube_player_viewPlayer);
        this.youtubeVideoId = this.getIntent().getExtras().getString(ARG_ID_KEY);
        this.getLifecycle().addObserver((LifecycleObserver)this.youTubePlayerView);
        this.youTubePlayerView.initialize(new YouTubePlayerInitListener(){

            public void onInitSuccess(final @NonNull YouTubePlayer youTubePlayer) {
                youTubePlayer.addListener((YouTubePlayerListener)new AbstractYouTubePlayerListener(){

                    public void onReady() {
                        YouTubePlayerActivity.this.loadVideo(youTubePlayer, YouTubePlayerActivity.this.youtubeVideoId);
                    }
                });
                YouTubePlayerActivity.this.addFullScreenListenerToPlayer(youTubePlayer);
            }
        }, true);
    }

    private void loadVideo(YouTubePlayer youTubePlayer, String videoId) {
        if (this.getLifecycle().getCurrentState() == Lifecycle.State.RESUMED) {
            youTubePlayer.loadVideo(videoId, 0.0f);
        } else {
            youTubePlayer.cueVideo(videoId, 0.0f);
        }
    }

    private void addFullScreenListenerToPlayer(final YouTubePlayer youTubePlayer) {
        this.youTubePlayerView.addFullScreenListener(new YouTubePlayerFullScreenListener(){

            public void onYouTubePlayerEnterFullScreen() {
                YouTubePlayerActivity.this.setRequestedOrientation(0);
                YouTubePlayerActivity.this.fullScreenHelper.enterFullScreen((View)YouTubePlayerActivity.this.youTubePlayerView);
                YouTubePlayerActivity.this.addCustomActionToPlayer(youTubePlayer);
            }

            public void onYouTubePlayerExitFullScreen() {
                YouTubePlayerActivity.this.setRequestedOrientation(1);
                YouTubePlayerActivity.this.fullScreenHelper.exitFullScreen((View)YouTubePlayerActivity.this.youTubePlayerView);
                YouTubePlayerActivity.this.removeCustomActionFromPlayer();
            }
        });
    }

    private void addCustomActionToPlayer(final YouTubePlayer youTubePlayer) {
        Drawable customActionIcon = ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_pause_36dp);
        this.youTubePlayerView.getPlayerUIController().setCustomAction1(customActionIcon, new View.OnClickListener(){

            public void onClick(View v) {
                if (youTubePlayer != null) {
                    youTubePlayer.pause();
                }
            }
        });
    }

    private void removeCustomActionFromPlayer() {
        this.youTubePlayerView.getPlayerUIController().showCustomAction1(false);
    }
}

