/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Point;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.ConciergeFragment;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final SimpleDateFormat TIMESTAMP_FLYBITS_JSON_DATE = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("MMMM d, yyyy' - 'h:mma");
    private static final SimpleDateFormat DATE_FULL_FORMAT = new SimpleDateFormat("EEE, MMMM d, yyyy");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("h:mma");
    private static final SimpleDateFormat WEEK_DAY_FORMAT = new SimpleDateFormat("EEEE", Locale.US);

    public static String fromCalendar(Calendar calendar) {
        Date date = calendar.getTime();
        String formatted = TIMESTAMP_FLYBITS_JSON_DATE.format(date);
        return formatted.substring(0, 22) + ":" + formatted.substring(22);
    }

    public static String now() {
        return Utils.fromCalendar(GregorianCalendar.getInstance());
    }

    public static Calendar toCalendar(String iso8601string) throws ParseException {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getDefault());
        String s = iso8601string.replace("Z", "+00:00");
        try {
            s = s.substring(0, 22) + s.substring(23);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Invalid length", 0);
        }
        Date date = TIMESTAMP_FLYBITS_JSON_DATE.parse(s);
        calendar.setTime(date);
        return calendar;
    }

    public static String getDateRange(Date startDate, Date endDate) {
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(startDate);
        endCal.setTime(endDate);
        boolean sameDay = startCal.get(1) == endCal.get(1) && startCal.get(6) == endCal.get(6);
        return String.format(Locale.getDefault(), "%s to %s", DATE_TIME_FORMAT.format(startDate), sameDay ? TIME_FORMAT.format(endDate) : DATE_TIME_FORMAT.format(endDate));
    }

    public static String getTimeRange(Date startDate, Date endDate) {
        return String.format(Locale.getDefault(), "%s - %s", TIME_FORMAT.format(startDate), TIME_FORMAT.format(endDate));
    }

    public static String getDateString(Date date) {
        return DATE_FULL_FORMAT.format(date);
    }

    public static String getTimeString(Date date) {
        return TIME_FORMAT.format(date);
    }

    public static String getWeekDayString(Date date) {
        return WEEK_DAY_FORMAT.format(date);
    }

    public static ConciergeFragment getConciergeFragment(FragmentActivity activity) {
        List fragments = activity.getSupportFragmentManager().getFragments();
        for (Fragment fragment : fragments) {
            if (!(fragment instanceof ConciergeFragment)) continue;
            return (ConciergeFragment)fragment;
        }
        return null;
    }

    public static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query2 = url.getQuery();
        for (String pair : pairs = query2.split("&")) {
            int idx = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()), URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()));
        }
        return query_pairs;
    }

    public static int screenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return size.x;
    }

    public static float screenWidthDp(Context context) {
        float density = context.getResources().getDisplayMetrics().density;
        return (float)Utils.screenWidth(context) / density;
    }

    public static void dismissKeyboard(Activity activity) {
        InputMethodManager imm;
        View v = activity.getWindow().getCurrentFocus();
        if (v != null && (imm = (InputMethodManager)activity.getSystemService("input_method")) != null && imm.isAcceptingText()) {
            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
        }
    }

    @Nullable
    public static Class<Activity> launcherActivity(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent mainIntent = new Intent("android.intent.action.MAIN", null);
            mainIntent.addCategory("android.intent.category.LAUNCHER");
            List appList = packageManager.queryIntentActivities(mainIntent, 0);
            for (ResolveInfo info : appList) {
                if (!context.getPackageName().equals(info.activityInfo.packageName)) continue;
                return Class.forName(info.activityInfo.name);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.exception((String)"Utils.launcherActivity", (Exception)e);
        }
        return null;
    }

    public static boolean isAppActive(Context context) {
        ActivityManager mgr = (ActivityManager)context.getSystemService("activity");
        if (mgr != null) {
            for (ActivityManager.RunningAppProcessInfo app : mgr.getRunningAppProcesses()) {
                if (app.importance != 100) continue;
                return app.processName.equals(context.getPackageName());
            }
        }
        return false;
    }
}

