package com.flybits.concierge.views;

import android.content.Context;
import com.google.android.material.textfield.TextInputEditText;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;

import com.flybits.concierge.R;

public class SurveyShortAnswer extends SurveyBaseView
{
    private String defaultText;
    private TextInputEditText input;

    public SurveyShortAnswer(Context context, String text)
    {
        super(context);
        defaultText = text;
        init(null, 0);
    }

    public SurveyShortAnswer(Context context)
    {
        super(context);
        init(null, 0);
    }

    public SurveyShortAnswer(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(attrs, 0);
    }

    public SurveyShortAnswer(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle)
    {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.flybits_con_view_survey_short_answer, this, true);

        input = view.findViewById(R.id.flybits_con_view_survey_short_answer_editText);
        input.setText(defaultText);
        input.addTextChangedListener(new TextWatcher()
        {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after)
            {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count)
            {

            }

            @Override
            public void afterTextChanged(Editable s)
            {
                callOnClick();
            }
        });
    }

    @Override
    public Object getAnswer()
    {
        String answer = input.getText().toString().trim();

        return TextUtils.isEmpty(answer) ? null : answer;
    }
}
