package com.flybits.concierge.views;

import android.content.Context;
import androidx.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.android.kernel.reservedtemplates.survey.models.QuestionChoice;
import com.flybits.concierge.R;

import java.util.ArrayList;
import java.util.List;

public class SurveyDropDown extends SurveyBaseView
{
    private int choice;
    private List<QuestionChoice> choices;
    private Button selectButton;
    private List<String> items;

    public SurveyDropDown(Context context, List<QuestionChoice> choices, int choice)
    {
        super(context);
        this.choices = choices;
        this.choice = choice;
        init(null, 0);
    }

    public SurveyDropDown(Context context)
    {
        super(context);
        init(null, 0);
    }

    public SurveyDropDown(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(attrs, 0);
    }

    public SurveyDropDown(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle)
    {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.flybits_con_view_survey_drop_down, this, true);

        items = new ArrayList<>(choices.size());
        for (QuestionChoice choice : choices)
        {
            items.add(choice.value.getValue());
        }

        selectButton = view.findViewById(R.id.flybits_con_view_survey_drop_down_btnOptions);
    }

    @Override
    protected void onAttachedToWindow()
    {
        super.onAttachedToWindow();

        String text = choice >= 0 ? items.get(choice) : null;

        if (text != null)
        {
            selectButton.setText(text);
        }

        selectButton.setOnClickListener(new OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                new MaterialDialog.Builder(getContext())
                        .title("Options")
                        .items(items)
                        .itemsCallback(new MaterialDialog.ListCallback() {
                            @Override
                            public void onSelection(MaterialDialog dialog, View view, int which, CharSequence text)
                            {
                                selectButton.setText(items.get(which));
                                choice = which;
                                callOnClick();
                            }
                        })
                        .negativeText(android.R.string.cancel)
                        .positiveText("clear")
                        .onPositive(new MaterialDialog.SingleButtonCallback()
                        {
                            @Override
                            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which)
                            {
                                selectButton.setText(R.string.flybits_con_view_survey_drop_down_select);
                                callOnClick();
                            }
                        })
                        .show();
            }
        });
    }

    @Override
    public Object getAnswer()
    {
        if (choice < 0)
        {
            return null;
        }

        return choice;
    }
}
