package com.flybits.concierge.viewmodels;

import android.app.Application;
import androidx.lifecycle.AndroidViewModel;
import androidx.annotation.NonNull;

import com.twitter.sdk.android.core.models.Tweet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TwitterViewModel extends AndroidViewModel
{
    private Map<String, List<Tweet>> tweetLists;

    public TwitterViewModel(@NonNull Application application)
    {
        super(application);

        tweetLists = new HashMap<>();
    }

    public List<Tweet> getTweetList(@NonNull String key)
    {
        List<Tweet> viewList = tweetLists.get(key);

        if (viewList == null)
        {
            viewList = new ArrayList<>();
            tweetLists.put(key, viewList);
        }

        return viewList;
    }

    public void clearTweetLists()
    {
        tweetLists.clear();
    }
}
