package com.flybits.concierge.viewmodels;

import android.app.Application;
import androidx.lifecycle.AndroidViewModel;
import androidx.annotation.NonNull;
import android.util.LongSparseArray;

import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.reservedtemplates.survey.models.SurveyAnswer;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;

public class SurveyViewModel extends AndroidViewModel
{
    private LongSparseArray<Object> answers;
    private BasicResultCallback basicResultCallback;
    private boolean isSubmitting;

    public SurveyViewModel(@NonNull Application application)
    {
        super(application);
        answers = new LongSparseArray<>();
    }

    public LongSparseArray<Object> getAnswers()
    {
        return answers;
    }

    public void setBasicResultCallback(BasicResultCallback callback)
    {
        basicResultCallback = callback;
    }

    public boolean isSubmitting()
    {
        return isSubmitting;
    }

    public void submitSurveyAnswers(SurveyAnswer surveyAnswer, Content content)
    {
        isSubmitting = true;

        surveyAnswer.saveSurveyAnswers(getApplication().getApplicationContext(), content, new BasicResultCallback()
        {
            @Override
            public void onSuccess()
            {
                isSubmitting = false;
                if (basicResultCallback != null)
                {
                    basicResultCallback.onSuccess();
                }
            }

            @Override
            public void onException(FlybitsException exception)
            {
                isSubmitting = false;
                if (basicResultCallback != null)
                {
                    basicResultCallback.onException(exception);
                }
            }
        });
    }
}
