package com.flybits.concierge.viewmodels

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel

import com.flybits.commons.library.api.results.callbacks.BasicResultCallback
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.concierge.FlybitsConcierge

class SettingsViewModel(private val flybitsConcierge: FlybitsConcierge) : ViewModel() {

    data class OptOutResult(val success: Boolean, val error: FlybitsException? = null)

    fun optOut(): LiveData<OptOutResult> {
        val liveData = MutableLiveData<OptOutResult>()
        flybitsConcierge.optOut(object : BasicResultCallback {
            override fun onSuccess() {
                liveData.postValue(OptOutResult(true))
            }

            override fun onException(e: FlybitsException) {
                liveData.postValue(OptOutResult(false, e))
            }
        })
        return liveData
    }
}
