package com.flybits.concierge.viewmodels

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.ResourceProvider

class OptInViewModelFactory(private val context: Context): ViewModelProvider.Factory {

    override fun <T : ViewModel?> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(OptInViewModel::class.java)){
            OptInViewModel(FlybitsConcierge.with(context), ResourceProvider(context)) as T
        } else {

            throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}