package com.flybits.concierge.viewholders;

import androidx.annotation.NonNull;
import android.view.View;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.fragments.OnboardingFragment;
import com.flybits.concierge.models.Onboarding;
import com.flybits.concierge.viewpopulators.OnboardingViewPopulator;

public class OnboardingViewHolder extends FlybitsViewHolder<Onboarding>
{

    private View thisView;
    private TextView titleTextView;
    private OnboardingViewPopulator onboardingViewPopulator;

    public OnboardingViewHolder(View itemView, OnboardingViewPopulator onboardingViewPopulator)
    {
        super(itemView);
        this.thisView = itemView;
        titleTextView = itemView.findViewById(R.id.flybits_con_item_on_boarding_txtTitle);
        this.onboardingViewPopulator = onboardingViewPopulator;
    }

    @Override
    public void bindData(@NonNull final Onboarding data, final FlybitsNavigator flybitsNavigator)
    {
        onboardingViewPopulator.populate(data, titleTextView);

        thisView.setOnClickListener(v -> {
            OnboardingFragment fragment = OnboardingFragment.newInstance(data);
            flybitsNavigator.openFragment(fragment, true);
        });
    }
}
