package com.flybits.concierge.repository.category

import androidx.sqlite.db.SupportSQLiteDatabase
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import androidx.room.migration.Migration
import android.content.Context
import com.flybits.concierge.models.Category

@Database(entities = [Category::class], version = 2)
@TypeConverters(SetConverter::class)
abstract class CategoryDatabase: RoomDatabase() {

    abstract fun categoryDao(): CategoryDao

    companion object {
        var INSTANCE: CategoryDatabase? = null

        fun getInstance(context: Context, debug: Boolean = false): CategoryDatabase? {
            if (INSTANCE == null){
                synchronized(CategoryDatabase::class){
                    val builder = Room.databaseBuilder(context, CategoryDatabase::class.java, "flybits-categories-db")
                    if (debug){
                        builder.allowMainThreadQueries()
                    }
                    INSTANCE = builder
                            .fallbackToDestructiveMigration()
                            .addMigrations(MIGRATION_2)
                            .build()
                }
            }

            return INSTANCE
        }

        fun destroyInstance() {
            INSTANCE = null
        }

        //Structure of Category was changed to include set of labels
        val MIGRATION_2: Migration = object : Migration(1, 2) {
            override fun migrate(database: SupportSQLiteDatabase) {
                database.execSQL("DELETE FROM ${Category.TABLE_NAME}")
                database.execSQL("ALTER TABLE ${Category.TABLE_NAME} ADD COLUMN ${Category.COLUMN_LABELS} TEXT NOT NULL DEFAULT '[]'")
            }
        }
    }
}