package com.flybits.concierge.repository.category

import androidx.lifecycle.LiveData
import androidx.room.*
import com.flybits.concierge.models.Category

@Dao
abstract class CategoryDao{

    @Query("SELECT * from category")
    abstract fun getAll(): LiveData<MutableList<Category>>

    @Query("DELETE from category")
    abstract fun deleteAll(): Int

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    abstract fun insert(categories: List<Category>)

    @Transaction
    open fun deleteAndInsertTransaction(insertCategories: List<Category>) {
        deleteAll()
        insert(insertCategories)
    }
}