package com.flybits.concierge.fragments;


import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.Utils;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.viewholders.VideoViewHolder;
import com.flybits.concierge.viewpopulators.VideoViewPopulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VideoPlaylistFragment extends Fragment
{
    private static final String ARG_VIDEOS = "flybits_con_playlist_args";

    private List<Video> videos;
    private FlybitsNavigator flybitsNavigator;
    private RecyclerView recyclerView;
    private TextView titleView;
    private VideoViewPopulator videoViewPopulator;

    public VideoPlaylistFragment()
    {
        // Required empty public constructor
    }

    public static VideoPlaylistFragment newInstance(ArrayList<Video> videos)
    {
        VideoPlaylistFragment fragment = new VideoPlaylistFragment();
        Bundle args = new Bundle();
        args.putParcelableArrayList(ARG_VIDEOS, videos);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (getArguments() != null)
        {
            videos = getArguments().getParcelableArrayList(ARG_VIDEOS);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_video_playlist, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        //Get the flybits navigator
        FragmentActivity activity = getActivity();
        if (activity instanceof FlybitsNavigator){
            flybitsNavigator = (FlybitsNavigator)getActivity();
        } else if (activity != null){
            flybitsNavigator = Utils.getConciergeFragment(activity);
        }

        videoViewPopulator = new VideoViewPopulator(new ContentAnalytics(getContext().getApplicationContext()));

        titleView = view.findViewById(R.id.flybits_con_fragment_video_playlist_txtTitle);

        recyclerView = view.findViewById(R.id.flybits_con_fragment_video_playlist_lytRecycler);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        recyclerView.setAdapter(new PlaylistAdapter());

        titleView.setText(String.format(Locale.getDefault(), "%d Videos", videos.size()));
    }

    private class PlaylistAdapter extends RecyclerView.Adapter<VideoViewHolder>
    {

        @NonNull
        @Override
        public VideoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
        {
            return new VideoViewHolder(videoViewPopulator, LayoutInflater.from(parent.getContext()).inflate(R.layout.flybits_con_item_template_video, parent, false));
        }

        @Override
        public void onBindViewHolder(@NonNull VideoViewHolder holder, int position)
        {
            holder.bindData(videos.get(position), flybitsNavigator);
        }

        @Override
        public int getItemCount()
        {
            return videos != null ? videos.size() : 0;
        }
    }
}