package com.flybits.concierge.fragments;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.ImageViewerActivity;
import com.flybits.concierge.models.Image;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ImageViewerPagerFragment extends Fragment {

    PagedArray<Image> images;
    ViewPager pgrPager;
    PagerAdapter adapter;
    TextView txtCounter;

    public static ImageViewerPagerFragment newInstance(PagedArray<Image> imageList, int startIndex) {
        ImageViewerPagerFragment frag = new ImageViewerPagerFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("list", imageList);
        bundle.putInt("start", startIndex);
        frag.setArguments(bundle);
        return frag;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.flybits_con_fragment_imageviewerpager, container, false);

        pgrPager = v.findViewById(R.id.flybits_con_fragment_imageviewpager_pgrImages);
        txtCounter = v.findViewById(R.id.flybits_con_fragment_imageviewpager_txtIndex);

        images = getArguments() != null ? (PagedArray<Image>) getArguments().getParcelable("list") : null;

        if (images == null)
            return v;

        adapter = new PagerAdapter(getActivity(), getFragmentManager(), images.getList());

        pgrPager.setAdapter(adapter);
        int index = getArguments().getInt("start", 0);
        pgrPager.setCurrentItem(index);
        getActivity().setTitle(images.getList().get(index).title.getValue());

        pgrPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                setCounter(position+1, images.getList().size());
                Activity activity = getActivity();
                if (activity instanceof ImageViewerActivity){
                    activity.setTitle(images.getList().get(position).title.getValue());
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        setCounter(pgrPager.getCurrentItem() + 1, images.getList().size());

        return v;
    }

    static class PagerAdapter extends FragmentStatePagerAdapter {

        Context context;
        List<Image> images;

        PagerAdapter(Context context, FragmentManager fm, ArrayList<Image> images) {
            super(fm);
            this.context = context;
            this.images = images;
        }

        @Override
        public Fragment getItem(int position) {
            return ImageFragment.newInstance(images.get(position).url, false, false, 0);
        }

        @Override
        public int getCount() {
            return images.size();
        }

    }

    private void setCounter(int current, int max)
    {
        txtCounter.setText(String.format(Locale.getDefault(), "%d/%d", current, max));
    }

}
