package com.flybits.concierge.fragments;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.concierge.R;

import java.util.Locale;

public class ImageFragment extends Fragment {

    private final static String ARG_IMAGEURI = "arg_uri";
    private final static String ARG_ISMORE = "arg_isMore";
    private final static String ARG_MORECOUNT = "arg_moreCount";
    private final static String ARG_CENTERCROP = "arg_centercrop";

    ImageView imgImage;
    LinearLayout lytMore;
    String imageUri;
    TextView txtMoreLabel;
    View.OnClickListener clickListener;
    boolean isMore = false;

    public static ImageFragment newInstance(String uri, boolean centerCrop, boolean isMore, int moreCount)
    {
        ImageFragment frag = new ImageFragment();
        Bundle args = new Bundle();
        args.putString(ARG_IMAGEURI, uri);
        args.putBoolean(ARG_CENTERCROP, centerCrop);
        args.putBoolean(ARG_ISMORE, isMore);
        args.putInt(ARG_MORECOUNT, moreCount);
        frag.setArguments(args);
        return frag;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.flybits_con_fragment_imageview, container, false);
        imgImage = v.findViewById(R.id.flybits_con_fragment_imageviewer_imgImage);
        lytMore = v.findViewById(R.id.flybits_con_fragment_imageviewer_lytMore);
        txtMoreLabel = v.findViewById(R.id.flybits_con_fragment_imageviewer_txtMore);
        imgImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageUri = getArguments().getString(ARG_IMAGEURI);
        isMore = getArguments().getBoolean(ARG_ISMORE, false);
        imgImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (clickListener != null)
                    clickListener.onClick(view);
            }
        });
        imgImage.setScaleType(getArguments().getBoolean(ARG_CENTERCROP, true) ? ImageView.ScaleType.CENTER_CROP : ImageView.ScaleType.FIT_CENTER);

        if (isMore) {
            lytMore.setVisibility(View.VISIBLE);
            int moreCount = getArguments().getInt(ARG_MORECOUNT, -1);
            if (moreCount > 0)
                txtMoreLabel.setText(String.format(Locale.getDefault(), "View %d more", moreCount));
            else
                txtMoreLabel.setText(R.string.flybits_con_fragment_image_view_more);
        }
        else
            lytMore.setVisibility(View.GONE);

        return v;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        RequestOptions options = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);

        Glide.with(view.getContext())
                .load(imageUri)
                .apply(options)
                .into(imgImage);
    }

    public void setImageOnClickListener(View.OnClickListener listener)
    {
        clickListener = listener;
    }
}
