package com.flybits.concierge.adapters;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.viewpopulators.ArticlesViewPopulator;

import java.util.ArrayList;
import java.util.List;

public class ArticleAdapter extends PagerAdapter
{
    private List<Article> data;
    private String parentContentId = "";
    private ArticlesViewPopulator articlesViewPopulator;

    public ArticleAdapter(ArticlesViewPopulator articlesViewPopulator)
    {
        this.articlesViewPopulator = articlesViewPopulator;
        data = new ArrayList<>();
    }

    public void setData(List<Article> data, String parentContentId)
    {
        this.data = data;
        this.parentContentId = parentContentId;
        notifyDataSetChanged();
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position)
    {

        // inflate our layout resource
        View itemView = LayoutInflater.from(container.getContext()).inflate(R.layout.flybits_con_item_article, container, false);

        container.addView(itemView);

        // get data
        Article article = data.get(position);

        // get fields
        TextView title = itemView.findViewById(R.id.flybits_con_article_txtTitle);
        TextView description = itemView.findViewById(R.id.flybits_con_article_txtDescription);
        TextView source = itemView.findViewById(R.id.flybits_con_article_txtSource);
        ImageView imageView = itemView.findViewById(R.id.flybits_con_article_imgHeader);

        articlesViewPopulator.populate(article, parentContentId, imageView, title, source, description, itemView);

        return itemView;
    }

    @Override
    public int getCount()
    {
        return data.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object object)
    {
        return view == object;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object)
    {
        container.removeView((View) object);
    }
}
