package com.flybits.concierge.activities

import android.content.Intent
import androidx.fragment.app.Fragment
import com.flybits.concierge.fragments.EventDetailsFragment
import com.flybits.concierge.models.Event

class EventDetailsActivity: SingleFragmentActivity() {

    companion object {
        const val EXTRA_EVENT_DETAILS = "flybits_con_extra_event_details"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        val eventDetails = intent.getParcelableExtra<Event>(EXTRA_EVENT_DETAILS)
        title = eventDetails.title.value
        return EventDetailsFragment.newInstance(eventDetails)
    }
}