package com.flybits.concierge.models;

import android.os.Parcel;

import com.flybits.android.kernel.models.LocalizedValue;

public class OnboardingPage extends BaseTemplate
{
    public LocalizedValue title;
    public LocalizedValue description;
    public String imageUrl;

    public OnboardingPage()
    {
    }

    protected OnboardingPage(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        imageUrl = in.readString();
    }

    public static final Creator<OnboardingPage> CREATOR = new Creator<OnboardingPage>()
    {
        @Override
        public OnboardingPage createFromParcel(Parcel in)
        {
            return new OnboardingPage(in);
        }

        @Override
        public OnboardingPage[] newArray(int size)
        {
            return new OnboardingPage[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(imageUrl);
    }
}
