package com.flybits.concierge.enums;

public enum ScheduleDay
{
    UNKNOWN("Unknown"), MONDAY("Monday"), TUESDAY("Tuesday"), WEDNESDAY("Wednesday"), THURSDAY("Thursday"), FRIDAY("Friday"), SATURDAY("Saturday"), WEEKDAY("Weekday"), SUNDAY("Sunday"), WEEKEND("Weekend"), EVERYDAY("Everyday");

    private String text;

    ScheduleDay(String text)
    {
        this.text = text;
    }

    public String getText()
    {
        return this.text;
    }

    public static ScheduleDay fromString(String text)
    {
        for (ScheduleDay day : ScheduleDay.values())
        {
            if (day.text.contentEquals(text))
            {
                return day;
            }
        }

        return UNKNOWN;
    }
}
