package com.flybits.concierge

import android.os.Bundle
import android.support.v4.app.Fragment

interface FlybitsNavigator {

    /**
     * Replaces the {@link CategoryFragment} which hosts the recycler view, with the provided fragment.
     *
     * @param fragment The fragment that will be navigated to.
     * @param addToBackStack Whether or not to add the fragment to the fragment managers back stack
     * , default value is true.
     */
    fun openFragment(fragment: Fragment, addToBackStack: Boolean = true)

    /**
     * Starts an activity using the provided intent.
     *
     * @param activity [Class] of the activity to be launched.
     * @param extras [Bundle] that will be passed to the activity
     */
    fun openActivity(activity: Class<*>, extras: Bundle)

    /**
     * Opens the provided url in the user selected browser.
     *
     * @url url that will be navigated to in the browser.
     *
     * @return true if the url could be opened successfully, false otherwise.
     */
    fun openUrl(url: String): Boolean

    /**
     * Opens a dialog within the {@link CategoryFragment} with the provided title, and content.
     *
     * @param content The content text that will appear in the body of the dialog.
     * @param title The title that will appear in the header of the dialog.
     *
     */
    fun openDialog(content: String, title: String)

    /**
     * Display a [Snackbar]
     *
     * @param content Message to be displayed in the [Snackbar]
     * @param length How long the snackbar should appear. Reference [Snackbar.LENGTH] constant.
     */
    fun openSnackbar(content: String, length: Int)

    /**
     * Dismiss currently visible content type.
     */
    fun dismiss()
}