package com.flybits.concierge

import android.os.Parcelable
import com.flybits.concierge.enums.ShowMode
import kotlinx.android.parcel.Parcelize

/**
 * Describes how the Concierge should be displayed to the end user.
 *
 * @param menuType The [MenuType] to be used in the navigation bar.
 * @param showMode The [ShowMode] that the Concierge will be displayed with.
 * @param showOptOutOption Whether the option to opt out should be displayed to the user throughout the Concierge.
 *
 */
@Parcelize
data class DisplayConfiguration(
    val menuType: ConciergeFragment.MenuType,
    val showMode: ShowMode,
    val showOptOutOption: Boolean
): Parcelable