package com.flybits.concierge;

import com.flybits.commons.library.exceptions.FlybitsException;

/**
 * Registered in the {@code FlybitsConcierge} and is notified about authentication status changes.
 * Each callback may be invoked more than once if several authentication requests are sent.
 */
public interface AuthenticationStatusListener {

    String AUTHENTICATION_STARTED = "authentication_started";
    String AUTHENTICATED = "authenticated";
    String ERROR = "error";

    /**
     * Invoked if the user has been authenticated successfully.
     */
    void onAuthenticated();

    /**
     * Invoked once authentication has started.
     */
    void onAuthenticationStarted();

    /**
     * Invoked if an error occurs during authentication.
     *
     * @param e Exception thrown during authentication.
     */
    void onAuthenticationError(FlybitsException e);

}
