/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewmodels;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModel;
import android.arch.paging.DataSource;
import android.arch.paging.LivePagedListBuilder;
import android.arch.paging.PagedList;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.results.ContentResult;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.APIUsageExceededException;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.NotConnectedException;
import com.flybits.commons.library.exceptions.UserOptedOutException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.commons.library.utils.jbool_expressions.And;
import com.flybits.commons.library.utils.jbool_expressions.Expression;
import com.flybits.commons.library.utils.jbool_expressions.Variable;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.R;
import com.flybits.concierge.ResourceProvider;
import com.flybits.concierge.analytics.ContentViewer;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.Category;
import com.flybits.concierge.repository.ModelConverter;
import com.flybits.concierge.repository.content.BaseTemplateDataSource;
import com.flybits.concierge.repository.content.ContentRepository;
import com.flybits.concierge.viewmodels.CategoryViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 ;2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0002;<B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010(\u001a\u00020'J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020'H\u0016J\u0014\u0010-\u001a\u00020'2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140/J\u001e\u00100\u001a\u00020'2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u0003022\u0006\u00103\u001a\u000204H\u0016J\u0016\u00105\u001a\u00020'2\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020'0&J\b\u00107\u001a\u00020'H\u0002J\u000e\u00108\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dJ \u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020\u001f2\u0010\b\u0002\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010/R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u000e\u0010\"\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/flybits/concierge/viewmodels/CategoryViewModel;", "Landroid/arch/lifecycle/ViewModel;", "Lcom/flybits/commons/library/api/results/callbacks/PagedResultCallback;", "Lcom/flybits/android/kernel/models/Content;", "category", "Lcom/flybits/concierge/models/Category;", "flybitsConcierge", "Lcom/flybits/concierge/FlybitsConcierge;", "contentRepository", "Lcom/flybits/concierge/repository/content/ContentRepository;", "contentViewer", "Lcom/flybits/concierge/analytics/ContentViewer;", "resourceProvider", "Lcom/flybits/concierge/ResourceProvider;", "modelConverter", "Lcom/flybits/concierge/repository/ModelConverter;", "(Lcom/flybits/concierge/models/Category;Lcom/flybits/concierge/FlybitsConcierge;Lcom/flybits/concierge/repository/content/ContentRepository;Lcom/flybits/concierge/analytics/ContentViewer;Lcom/flybits/concierge/ResourceProvider;Lcom/flybits/concierge/repository/ModelConverter;)V", "contentDataSource", "Landroid/arch/paging/DataSource;", "", "Lcom/flybits/concierge/models/BaseTemplate;", "contentResult", "Lcom/flybits/android/kernel/models/results/ContentResult;", "feedContent", "Landroid/arch/lifecycle/LiveData;", "Landroid/arch/paging/PagedList;", "getFeedContent", "()Landroid/arch/lifecycle/LiveData;", "feedErrorDisplayer", "Lcom/flybits/concierge/viewmodels/CategoryViewModel$FeedErrorDisplayer;", "gotLocal", "", "<set-?>", "isNoData", "lastVisibility", "loadedAll", "loadedContent", "onRefreshFinishedCallback", "Lkotlin/Function0;", "", "clean", "onException", "exception", "Lcom/flybits/commons/library/exceptions/FlybitsException;", "onLoadedAllItems", "onScroll", "visibleItems", "", "onSuccess", "items", "Ljava/util/ArrayList;", "pagination", "Lcom/flybits/commons/library/models/internal/Pagination;", "refresh", "refreshResultListener", "requestContent", "setFeedErrorDisplayer", "visibilityChange", "visible", "Companion", "FeedErrorDisplayer", "concierge_release"})
public final class CategoryViewModel
extends ViewModel
implements PagedResultCallback<Content> {
    private ContentResult contentResult;
    private Function0<Unit> onRefreshFinishedCallback;
    private FeedErrorDisplayer feedErrorDisplayer;
    private boolean loadedAll;
    private DataSource<Integer, BaseTemplate> contentDataSource;
    private boolean gotLocal;
    private boolean loadedContent;
    @NotNull
    private LiveData<Boolean> isNoData;
    private boolean lastVisibility;
    private final Category category;
    private final FlybitsConcierge flybitsConcierge;
    private final ContentRepository contentRepository;
    private final ContentViewer contentViewer;
    private final ResourceProvider resourceProvider;
    private final ModelConverter modelConverter;
    public static final int PAGE_SIZE = 20;
    public static final int PRE_FETCH_DISTANCE = 10;
    public static final int INITIAL_LOAD_SIZE = 20;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LiveData<Boolean> isNoData() {
        return this.isNoData;
    }

    @NotNull
    public final LiveData<PagedList<BaseTemplate>> getFeedContent() {
        this.loadedAll = false;
        PagedList.Config config = new PagedList.Config.Builder().setInitialLoadSizeHint(20).setPageSize(20).setEnablePlaceholders(true).setPrefetchDistance(10).build();
        ArrayList<String> typeList = new ArrayList<String>();
        Collection collection = this.flybitsConcierge.getFlybitsViewProviders();
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        for (FlybitsViewProvider viewProvider : collection) {
            typeList.add(viewProvider.getContentType());
        }
        Logger.d((String)("Category: " + this.category + ", returning LivePagedList"));
        DataSource.Factory<Integer, BaseTemplate> dataSourceFactory2 = BaseTemplateDataSource.Companion.getFactory(this.category.getName(), this.contentRepository, this.modelConverter, (Function1<? super DataSource<Integer, BaseTemplate>, Unit>)((Function1)new Function1<DataSource<Integer, BaseTemplate>, Unit>(this){
            final /* synthetic */ CategoryViewModel this$0;

            public final void invoke(@NotNull DataSource<Integer, BaseTemplate> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                CategoryViewModel.access$setContentDataSource$p(this.this$0, it);
            }
            {
                this.this$0 = categoryViewModel;
                super(1);
            }
        }));
        LiveData liveData = new LivePagedListBuilder(dataSourceFactory2, config).setBoundaryCallback((PagedList.BoundaryCallback)new PagedList.BoundaryCallback<BaseTemplate>(this){
            final /* synthetic */ CategoryViewModel this$0;

            public void onZeroItemsLoaded() {
                Logger.d((String)"onZeroItemsLoaded()");
                CategoryViewModel.access$requestContent(this.this$0);
            }

            public void onItemAtEndLoaded(@NotNull BaseTemplate itemAtEnd) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)itemAtEnd, (String)"itemAtEnd");
                    Logger.d((String)("Category: " + CategoryViewModel.access$getCategory$p(this.this$0) + ", onItemAtEndLoaded() "));
                    if (CategoryViewModel.access$getLoadedAll$p(this.this$0)) break block1;
                    ContentResult contentResult = CategoryViewModel.access$getContentResult$p(this.this$0);
                    if (contentResult != null) {
                        contentResult.getMore((PagedResultCallback)this.this$0);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        }).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)liveData, (String)"LivePagedListBuilder(dat\u2026 }\n            }).build()");
        LiveData livePagedList2 = liveData;
        livePagedList2.observeForever((Observer)new Observer<PagedList<BaseTemplate>>(this){
            final /* synthetic */ CategoryViewModel this$0;

            public final void onChanged(@Nullable PagedList<BaseTemplate> it) {
                Logger.d((String)("Category: " + CategoryViewModel.access$getCategory$p(this.this$0) + ", got local data, loadedContent = " + CategoryViewModel.access$getLoadedAll$p(this.this$0) + " gotLocal = " + CategoryViewModel.access$getGotLocal$p(this.this$0)));
                if (CategoryViewModel.access$getLoadedContent$p(this.this$0) && !CategoryViewModel.access$getGotLocal$p(this.this$0)) {
                    DataSource dataSource = CategoryViewModel.access$getContentDataSource$p(this.this$0);
                    if (dataSource != null) {
                        dataSource.invalidate();
                    }
                }
                CategoryViewModel.access$setGotLocal$p(this.this$0, true);
            }
            {
                this.this$0 = categoryViewModel;
            }
        });
        return livePagedList2;
    }

    public final void refresh(@NotNull Function0<Unit> refreshResultListener) {
        Intrinsics.checkParameterIsNotNull(refreshResultListener, (String)"refreshResultListener");
        this.loadedAll = false;
        this.contentResult = null;
        this.requestContent();
        this.onRefreshFinishedCallback = refreshResultListener;
    }

    public static /* synthetic */ void refresh$default(CategoryViewModel categoryViewModel, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = refresh.1.INSTANCE;
        }
        categoryViewModel.refresh((Function0<Unit>)function0);
    }

    public final void clean() {
        this.contentViewer.stop();
    }

    /*
     * WARNING - void declaration
     */
    private final void requestContent() {
        if (this.contentResult == null) {
            ContentParameters params;
            ContentParameters.Builder paramsBuilder = ((ContentParameters.Builder)new ContentParameters.Builder().setPaging((long)20, 0L)).setCaching(this.category.getName(), 20);
            if (!StringsKt.equals((String)this.category.getName(), (String)this.resourceProvider.getString(R.string.flybits_con_default_tab_name), (boolean)true)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.category.getLabels();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Variable variable = Variable.of((Object)it);
                    collection.add(variable);
                }
                List variables = (List)destination$iv$iv;
                if (variables.size() > 1) {
                    paramsBuilder.setLabels((Expression)And.of((List)variables));
                } else if (variables.size() == 1) {
                    paramsBuilder.setLabels((String)CollectionsKt.first((Iterable)this.category.getLabels()));
                }
            }
            ContentParameters contentParameters = params = paramsBuilder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentParameters, (String)"params");
            Set<String> set = this.flybitsConcierge.getViewProviderSupportedContentTypes();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"flybitsConcierge.viewProviderSupportedContentTypes");
            this.contentResult = this.contentRepository.getContent(contentParameters, set, (PagedResultCallback<Content>)((PagedResultCallback)this));
        }
    }

    public final void setFeedErrorDisplayer(@NotNull FeedErrorDisplayer feedErrorDisplayer) {
        Intrinsics.checkParameterIsNotNull((Object)feedErrorDisplayer, (String)"feedErrorDisplayer");
        this.feedErrorDisplayer = feedErrorDisplayer;
    }

    public void onSuccess(@NotNull ArrayList<Content> items, @NotNull Pagination pagination) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)pagination, (String)"pagination");
        Logger.d((String)("Category: " + this.category + ", onSuccess() items count: " + items.size()));
        Function0<Unit> function0 = this.onRefreshFinishedCallback;
        if (function0 != null) {
            Function0<Unit> function02 = function0;
            boolean bl = false;
            boolean bl2 = false;
            Function0<Unit> it = function02;
            boolean bl3 = false;
            it.invoke();
        }
        this.onRefreshFinishedCallback = null;
        this.loadedContent = true;
        if (this.gotLocal) {
            Logger.d((String)("Category: " + this.category + ", gotLocal = true, invalidating content data source"));
            DataSource<Integer, BaseTemplate> dataSource = this.contentDataSource;
            if (dataSource != null) {
                dataSource.invalidate();
            }
        }
        LiveData<Boolean> liveData = this.isNoData;
        if (liveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<kotlin.Boolean>");
        }
        ((MutableLiveData)liveData).postValue((Object)(items.size() == 0 ? 1 : 0));
    }

    public void onException(@NotNull FlybitsException exception) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
        String string2 = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"javaClass.simpleName");
        Logger.exception((String)string2, (Exception)((Exception)((Object)exception)));
        if (exception instanceof NotConnectedException || exception instanceof APIUsageExceededException) {
            this.flybitsConcierge.unauthenticateWithoutLogout(exception);
        }
        Function0<Unit> function0 = this.onRefreshFinishedCallback;
        if (function0 != null) {
            Function0<Unit> function02 = function0;
            boolean bl = false;
            boolean bl2 = false;
            Function0<Unit> it = function02;
            boolean bl3 = false;
            it.invoke();
        }
        this.onRefreshFinishedCallback = null;
        if (!(exception instanceof UserOptedOutException)) {
            FeedErrorDisplayer feedErrorDisplayer = this.feedErrorDisplayer;
            if (feedErrorDisplayer != null) {
                feedErrorDisplayer.onError(this.resourceProvider.getString(R.string.flybits_con_generic_error));
            }
        }
        LiveData<Boolean> liveData = this.isNoData;
        if (liveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<kotlin.Boolean>");
        }
        ((MutableLiveData)liveData).postValue((Object)false);
    }

    public void onLoadedAllItems() {
        this.loadedAll = true;
    }

    public final void visibilityChange(boolean visible, @Nullable List<? extends BaseTemplate> visibleItems) {
        Logger.setTag((String)"Concierge-DEBUG").d("CategoryViewModel line 201: VisibilityChange " + visible + " , " + this.lastVisibility);
        if (visible != this.lastVisibility) {
            this.lastVisibility = visible;
            if (visible && visibleItems != null) {
                Logger.setTag((String)"Concierge-DEBUG").d("CategoryViewModel line 205: visible && visibleItems");
                this.contentViewer.start(CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())));
                this.contentViewer.queueVisibilityEvent(new ContentViewer.VisibilityEvent(visibleItems));
            } else {
                Logger.setTag((String)"Concierge-DEBUG").d("CategoryViewModel line 209: else");
                this.contentViewer.stop();
            }
        }
    }

    public static /* synthetic */ void visibilityChange$default(CategoryViewModel categoryViewModel, boolean bl, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        categoryViewModel.visibilityChange(bl, list);
    }

    public final void onScroll(@NotNull List<? extends BaseTemplate> visibleItems) {
        Intrinsics.checkParameterIsNotNull(visibleItems, (String)"visibleItems");
        Logger.setTag((String)"Concierge-DEBUG").d("CategoryViewModel line 216: onScroll " + visibleItems.size());
        if (this.contentViewer.isRunning()) {
            this.contentViewer.queueVisibilityEvent(new ContentViewer.VisibilityEvent(visibleItems));
        }
    }

    public CategoryViewModel(@NotNull Category category, @NotNull FlybitsConcierge flybitsConcierge, @NotNull ContentRepository contentRepository, @NotNull ContentViewer contentViewer, @NotNull ResourceProvider resourceProvider, @NotNull ModelConverter modelConverter) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        Intrinsics.checkParameterIsNotNull((Object)flybitsConcierge, (String)"flybitsConcierge");
        Intrinsics.checkParameterIsNotNull((Object)contentRepository, (String)"contentRepository");
        Intrinsics.checkParameterIsNotNull((Object)contentViewer, (String)"contentViewer");
        Intrinsics.checkParameterIsNotNull((Object)resourceProvider, (String)"resourceProvider");
        Intrinsics.checkParameterIsNotNull((Object)modelConverter, (String)"modelConverter");
        this.category = category;
        this.flybitsConcierge = flybitsConcierge;
        this.contentRepository = contentRepository;
        this.contentViewer = contentViewer;
        this.resourceProvider = resourceProvider;
        this.modelConverter = modelConverter;
        this.isNoData = (LiveData)new MutableLiveData();
        this.loadedAll = false;
        LiveData<Boolean> liveData = this.isNoData;
        if (liveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<kotlin.Boolean>");
        }
        ((MutableLiveData)liveData).postValue((Object)false);
    }

    public static final /* synthetic */ DataSource access$getContentDataSource$p(CategoryViewModel $this) {
        return $this.contentDataSource;
    }

    public static final /* synthetic */ void access$setContentDataSource$p(CategoryViewModel $this, DataSource dataSource) {
        $this.contentDataSource = dataSource;
    }

    public static final /* synthetic */ void access$requestContent(CategoryViewModel $this) {
        $this.requestContent();
    }

    public static final /* synthetic */ Category access$getCategory$p(CategoryViewModel $this) {
        return $this.category;
    }

    public static final /* synthetic */ boolean access$getLoadedAll$p(CategoryViewModel $this) {
        return $this.loadedAll;
    }

    public static final /* synthetic */ void access$setLoadedAll$p(CategoryViewModel $this, boolean bl) {
        $this.loadedAll = bl;
    }

    public static final /* synthetic */ ContentResult access$getContentResult$p(CategoryViewModel $this) {
        return $this.contentResult;
    }

    public static final /* synthetic */ void access$setContentResult$p(CategoryViewModel $this, ContentResult contentResult) {
        $this.contentResult = contentResult;
    }

    public static final /* synthetic */ boolean access$getGotLocal$p(CategoryViewModel $this) {
        return $this.gotLocal;
    }

    public static final /* synthetic */ void access$setGotLocal$p(CategoryViewModel $this, boolean bl) {
        $this.gotLocal = bl;
    }

    public static final /* synthetic */ boolean access$getLoadedContent$p(CategoryViewModel $this) {
        return $this.loadedContent;
    }

    public static final /* synthetic */ void access$setLoadedContent$p(CategoryViewModel $this, boolean bl) {
        $this.loadedContent = bl;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/flybits/concierge/viewmodels/CategoryViewModel$FeedErrorDisplayer;", "", "onError", "", "err", "", "concierge_release"})
    public static interface FeedErrorDisplayer {
        public void onError(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/flybits/concierge/viewmodels/CategoryViewModel$Companion;", "", "()V", "INITIAL_LOAD_SIZE", "", "PAGE_SIZE", "PRE_FETCH_DISTANCE", "concierge_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

