package com.flybits.concierge.viewholders;

import android.content.Context;
import android.view.View;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.BaseTemplate;

public class UnknownViewHolder extends FlybitsViewHolder<BaseTemplate>
{
    TextView textView;

    public UnknownViewHolder(View itemView)
    {
        super(itemView);
        textView = (TextView) itemView;
    }

    @Override
    public void bindData(BaseTemplate data, FlybitsNavigator flybitsNavigator)
    {
        Context context = textView.getContext();
        textView.setText(data == null ? context.getString(R.string.flybits_con_empty_view): data.toString());
    }
}
