/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.res.XmlResourceParser;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.concierge.ConciergeConfiguration;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/flybits/concierge/ConciergeConfigurationXMLParser;", "", "()V", "GATEWAY_URL", "", "generateConfigurationFromXML", "Lcom/flybits/concierge/ConciergeConfiguration;", "xmlResourceParser", "Landroid/content/res/XmlResourceParser;", "concierge_release"})
public final class ConciergeConfigurationXMLParser {
    private static final String GATEWAY_URL = "gatewayUrl";
    public static final ConciergeConfigurationXMLParser INSTANCE;

    @NotNull
    public final ConciergeConfiguration generateConfigurationFromXML(@NotNull XmlResourceParser xmlResourceParser) {
        Intrinsics.checkParameterIsNotNull((Object)xmlResourceParser, (String)"xmlResourceParser");
        String projectID = null;
        String tncUrl = null;
        String privacyPolicyUrl = null;
        long timeToUploadContext = 0L;
        String gatewayUrl = null;
        String conciergeTag = "concierge";
        ConciergeConfiguration conciergeConfiguration = null;
        try {
            int eventType = xmlResourceParser.getEventType();
            ConciergeConfiguration.Builder conciergeConfigurationBuilder = null;
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String string2 = xmlResourceParser.getName();
                        if (!Intrinsics.areEqual((Object)string2, (Object)conciergeTag)) break;
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlResourceParser.getAttributeValue(null, "projectID"), (String)"xmlResourceParser.getAtt\u2026eValue(null, \"projectID\")");
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlResourceParser.getAttributeValue(null, "tncUrl"), (String)"xmlResourceParser.getAtt\u2026buteValue(null, \"tncUrl\")");
                        Intrinsics.checkExpressionValueIsNotNull((Object)xmlResourceParser.getAttributeValue(null, "privacyPolicyUrl"), (String)"xmlResourceParser.getAtt\u2026null, \"privacyPolicyUrl\")");
                        timeToUploadContext = xmlResourceParser.getAttributeIntValue(null, "timeToUploadContext", 10);
                        conciergeConfigurationBuilder = new ConciergeConfiguration.Builder(projectID).setPrivacyPolicyUrl(privacyPolicyUrl).setTermsAndServicesRequired(tncUrl).setTimeToUploadContext(timeToUploadContext);
                        if (xmlResourceParser.getAttributeValue(null, GATEWAY_URL) != null) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)xmlResourceParser.getAttributeValue(null, GATEWAY_URL), (String)"xmlResourceParser.getAtt\u2026eValue(null, GATEWAY_URL)");
                            conciergeConfigurationBuilder.setGatewayUrl(gatewayUrl);
                        }
                        conciergeConfiguration = conciergeConfigurationBuilder.build();
                        break;
                    }
                    case 3: {
                        String string2 = xmlResourceParser.getName();
                        if (!Intrinsics.areEqual((Object)string2, (Object)conciergeTag)) break;
                        ConciergeConfiguration conciergeConfiguration2 = conciergeConfiguration;
                        if (conciergeConfiguration2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"conciergeConfiguration");
                        }
                        return conciergeConfiguration2;
                    }
                }
                eventType = xmlResourceParser.next();
            }
            throw (Throwable)new FlybitsException("Incorrect Concierge Configuration XML Format : No Concierge tag found");
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw (Throwable)new IllegalStateException("Concierge: Cfg syntax error.");
        }
        catch (IOException ioException) {
            throw (Throwable)new IOException("Concierge: Error reading XML resource.");
        }
    }

    private ConciergeConfigurationXMLParser() {
    }

    static {
        ConciergeConfigurationXMLParser conciergeConfigurationXMLParser;
        INSTANCE = conciergeConfigurationXMLParser = new ConciergeConfigurationXMLParser();
    }
}

