package com.flybits.concierge.viewholders;

import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Articles;

public class ArticlesViewHolder extends FlybitsViewHolder<Articles>
{
    private ViewPager viewPager;
    private View singleView;
    private ImageView imgHeader;
    private TextView txtTitle;
    private TextView txtSource;
    private TextView txtDescription;
    private View thisView;
    private FlybitsViewPopulator flybitsViewPopulator;

    public ArticlesViewHolder(View itemView, FlybitsViewPopulator flybitsViewPopulator)
    {
        super(itemView);
        viewPager = itemView.findViewById(R.id.flybits_con_articles_viewPager);
        singleView = itemView.findViewById(R.id.flybits_con_articles_single);
        thisView = itemView;

        // single elements
        imgHeader = itemView.findViewById(R.id.flybits_con_article_imgHeader);
        txtTitle = itemView.findViewById(R.id.flybits_con_article_txtTitle);
        txtSource = itemView.findViewById(R.id.flybits_con_article_txtSource);
        txtDescription = itemView.findViewById(R.id.flybits_con_article_txtDescription);

        // Disable clip to padding
        viewPager.setClipToPadding(false);
        // set padding manually, the more you set the padding the more you see of prev & next page
        viewPager.setPadding(50, 0, 50, 0);
        // sets a margin b/w individual pages to ensure that there is a gap b/w them
        viewPager.setPageMargin(5);

        this.flybitsViewPopulator = flybitsViewPopulator;
    }

    @Override
    public void bindData(Articles data, FlybitsNavigator flybitsNavigator)
    {
        flybitsViewPopulator.populateArticlesViews(data, viewPager, singleView, imgHeader
                , txtTitle, txtSource, txtDescription, thisView);
    }
}
