package com.flybits.concierge.models;

import android.os.Parcel;

import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.Utils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class ScheduleSegment extends BaseTemplate
{
    public LocalizedValue title;
    public String url;
    public String startTime;
    public String endTime;
    public LocalizedValue description;

    private static Calendar today = Calendar.getInstance();

    private Date startDayTime;
    private Date endDayTime;

    public ScheduleSegment()
    {
    }

    protected ScheduleSegment(Parcel in)
    {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        url = in.readString();
        startTime = in.readString();
        endTime = in.readString();
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
    }

    public static final Creator<ScheduleSegment> CREATOR = new Creator<ScheduleSegment>()
    {
        @Override
        public ScheduleSegment createFromParcel(Parcel in)
        {
            return new ScheduleSegment(in);
        }

        @Override
        public ScheduleSegment[] newArray(int size)
        {
            return new ScheduleSegment[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        super.writeToParcel(dest,flags);
        dest.writeParcelable(title, flags);
        dest.writeString(url);
        dest.writeString(startTime);
        dest.writeString(endTime);
        dest.writeParcelable(description, flags);
    }

    public Date getStartDayTime()
    {
        if (startDayTime != null)
        {
            return startDayTime;
        }

        try
        {
            Calendar calendar = Utils.toCalendar(startTime);
            calendar.set(Calendar.DAY_OF_YEAR, today.get(Calendar.DAY_OF_YEAR));
            startDayTime = calendar.getTime();
        }
        catch (ParseException e)
        {
            Logger.exception(ScheduleSegment.class.getSimpleName(), e);
        }

        return startDayTime;
    }


    public Date getEndDayTime()
    {
        if (endDayTime != null)
        {
            return endDayTime;
        }

        try
        {
            Calendar calendar = Utils.toCalendar(endTime);
            calendar.set(Calendar.DAY_OF_YEAR, today.get(Calendar.DAY_OF_YEAR));
            endDayTime = calendar.getTime();
        }
        catch (ParseException e)
        {
            Logger.exception(ScheduleSegment.class.getSimpleName(), e);
        }

        return endDayTime;
    }
}
