package com.flybits.concierge.activities

import android.content.Context
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.view.MenuItem
import com.flybits.commons.library.analytics.Analytics
import com.flybits.concierge.R
import com.flybits.concierge.fragments.SettingsFragment


/**
 * This activity responsible for the display of settings. Hosts [SettingsFragment] which
 * contains majority of the UI.
 */
class SettingsActivity : AppCompatActivity() {

    internal var settingsFragment = SettingsFragment.newInstance(false)

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return if (item.itemId == android.R.id.home) {
            onBackPressed()
            true
        } else {
            super.onOptionsItemSelected(item)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_settings)

        val actionBar = supportActionBar
        actionBar?.setDisplayHomeAsUpEnabled(true)

        if (savedInstanceState == null) {
            supportFragmentManager.beginTransaction()
                    .replace(R.id.flybits_con_activity_settings_fragment_holder, settingsFragment)
                    .commit()
        }

        getAnalytics(applicationContext).flush(null, true)
    }


    companion object {
        const val RESULT_OPT_OUT = 8 //Result used to notify prior activity that OPT_OUT occurred
        const val REQUEST_CODE = 1

        var analytics: Analytics? = null

        /**
         *  Provides the analytics object used to send analytics to the server.
         *  This method is inside the companion object for testing purposes - to mock
         *  the returned analytics object when testing whether analytics are flushed or not
         */
        fun getAnalytics(context: Context) = analytics ?: Analytics(context).apply { analytics = this }
    }
}
