package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.android.kernel.db.KernelDatabase
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.FlybitsViewProviderGetter
import com.flybits.concierge.ResourceProvider
import com.flybits.concierge.models.Category
import com.flybits.concierge.repository.ModelConverter
import com.flybits.concierge.repository.content.ContentGetter
import com.flybits.concierge.repository.content.ContentRepository
import com.flybits.internal.db.CommonsDatabase

class CategoryViewModelFactory(context: Context, flybitsViewProviderGetter: FlybitsViewProviderGetter
                               , private val category: Category): ViewModelProvider.Factory {

    private val contentGetter = ContentGetter(context.applicationContext)
    private val flybitsConcierge = FlybitsConcierge.with(context.applicationContext)
    private val contentRepository: ContentRepository = ContentRepository(contentGetter
            , KernelDatabase.getDatabase(context.applicationContext).contentDao()
            , CommonsDatabase.getDatabase(context.applicationContext).cachingEntryDAO()
    )
    private val contentAnalytics: ContentAnalytics = ContentAnalytics(context.applicationContext)
    private val resourceProvider: ResourceProvider = ResourceProvider(context.applicationContext)
    private val modelConverter = ModelConverter(contentGetter, flybitsViewProviderGetter)

    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(CategoryViewModel::class.java)){
            CategoryViewModel(category, flybitsConcierge, contentRepository
                    , contentAnalytics, resourceProvider, modelConverter) as T
        } else {

            throw IllegalArgumentException("ViewModel Not Found")
        }
    }

}