package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.LinearLayout;

import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.models.Audios;

public class AudiosViewHolder extends FlybitsViewHolder<Audios>
{

    private ConciergeFragment conciergeFragment;
    private LinearLayout thisView;
    private FlybitsViewPopulator flybitsViewPopulator;

    public AudiosViewHolder(ConciergeFragment conFrag, View itemView, FlybitsViewPopulator flybitsViewPopulator)
    {
        super(itemView);
        this.conciergeFragment = conFrag;
        this.thisView = (LinearLayout) itemView;
        this.flybitsViewPopulator = flybitsViewPopulator;
    }

    @Override
    public void bindData(final Audios data, FlybitsNavigator flybitsNavigator)
    {
        flybitsViewPopulator.populateAudiosViews(data, thisView, conciergeFragment);
    }
}
