package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.ScheduleSegment;

public class ScheduleSegmentViewHolder extends FlybitsViewHolder<ScheduleSegment>
{
    private final TextView timeRangeView;
    private final TextView titleView;
    private final View clickableArea;
    private final FlybitsNavigator flybitsNavigator;
    private final View ruleView;
    private final TextView descriptionView;
    private final ImageView bulletOutView;
    private final ImageView bulletInView;
    private FlybitsViewPopulator flybitsViewPopulator;

    public ScheduleSegmentViewHolder(FlybitsNavigator flybitsNavigator, View itemView, FlybitsViewPopulator flybitsViewPopulator)
    {
        super(itemView);

        this.flybitsNavigator = flybitsNavigator;
        clickableArea = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_lytContainer);
        timeRangeView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTimeRange);
        titleView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtTitle);
        descriptionView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_txtDescription);
        ruleView =  itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_viewRuleBottom);
        bulletOutView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletOut);
        bulletInView = itemView.findViewById(R.id.flybits_con_item_template_schedule_segment_imgBulletIn);
        this.flybitsViewPopulator = flybitsViewPopulator;
    }

    @Override
    public void bindData(final ScheduleSegment data, FlybitsNavigator flybitsNavigator)
    {
        flybitsViewPopulator.populateScheduleSegmentViews(flybitsNavigator, data, clickableArea
                , timeRangeView, titleView, descriptionView, bulletOutView, bulletInView);
    }

    public void setLast(boolean last)
    {
        ruleView.setVisibility(last ? View.INVISIBLE : View.VISIBLE);
    }
}
