/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.android.kernel.KernelScope;
import com.flybits.android.push.PushManager;
import com.flybits.android.push.PushScope;
import com.flybits.android.push.models.Push;
import com.flybits.commons.library.SharedElementsFactory;
import com.flybits.commons.library.api.FlybitsManager;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.idps.IDP;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.concierge.AuthenticationStatusListener;
import com.flybits.concierge.ConciergeConfiguration;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.LogOutCallback;
import com.flybits.concierge.OptedStateChangeListener;
import com.flybits.concierge.activities.ConciergeActivity;
import com.flybits.concierge.activities.ConciergePopupActivity;
import com.flybits.concierge.activities.NotificationsActivity;
import com.flybits.concierge.enums.ShowMode;
import com.flybits.concierge.exception.ConciergeException;
import com.flybits.concierge.exception.ConciergeUninitializedException;
import com.flybits.concierge.repository.push.NotificationContentRepository;
import com.flybits.concierge.services.PreloadingWorker;
import com.flybits.concierge.viewproviders.ArticlesViewProvider;
import com.flybits.concierge.viewproviders.EventsViewProvider;
import com.flybits.concierge.viewproviders.ImageViewProvider;
import com.flybits.concierge.viewproviders.LinksViewProvider;
import com.flybits.concierge.viewproviders.OnboardingViewProvider;
import com.flybits.concierge.viewproviders.ScheduleViewProvider;
import com.flybits.concierge.viewproviders.SurveyViewProvider;
import com.flybits.concierge.viewproviders.TextViewProvider;
import com.flybits.concierge.viewproviders.TwitterViewProvider;
import com.flybits.concierge.viewproviders.VideosViewProvider;
import com.flybits.context.ContextManager;
import com.flybits.context.ContextScope;
import com.flybits.context.plugins.FlybitsContextPlugin;
import com.flybits.internal.db.CommonsDatabase;
import com.twitter.sdk.android.core.DefaultLogger;
import com.twitter.sdk.android.core.Twitter;
import com.twitter.sdk.android.core.TwitterAuthConfig;
import com.twitter.sdk.android.core.TwitterConfig;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FlybitsConcierge
implements FlybitsViewProviderGetter {
    private static FlybitsConcierge INSTANCE;
    private WeakReference<Context> lastProvidedContext;
    private ConciergeConfiguration currentConfig;
    private IDP idp;
    protected FlybitsManager flybitsManager;
    private NotificationContentRepository notificationContentRepository;
    private CommonsDatabase commonsDatabase;
    private final Set<OptedStateChangeListener> optedStateChangeListeners;
    private final Set<AuthenticationStatusListener> authenticationStatusListeners;
    private final Map<String, FlybitsViewProvider> flybitsViewProviders;
    private boolean authenticating = false;
    private boolean authenticationRequested = false;
    private boolean networkReceiverRegistered = false;
    private boolean initialized = false;
    private BroadcastReceiver networkReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
                if (manager != null && manager.getActiveNetworkInfo().isConnected() && FlybitsConcierge.this.isAutoRetryAuthenticationOnConnectedEnabled() && !FlybitsConcierge.this.isAuthenticated() && FlybitsConcierge.this.authenticationRequested) {
                    FlybitsConcierge.this.retryAuthentication();
                }
            }
            catch (Exception e) {
                Logger.exception((String)"networkReceiver.onReceive", (Exception)e);
            }
        }
    };
    private BasicResultCallback conciergeConnectionResultCallback = new BasicResultCallback(){

        public void onSuccess() {
            FlybitsConcierge.this.authenticating = false;
            FlybitsConcierge.this.broadcastAuthenticationState("authenticated");
            FlybitsConcierge.this.unregisterNetworkReceiver();
            boolean success = FlybitsConcierge.this.enablePushMessagingUsingLocalToken();
            Logger.setTag((String)FlybitsConcierge.class.getSimpleName()).d("Push messaging using local token success: " + success);
        }

        public void onException(FlybitsException exception) {
            FlybitsConcierge.this.authenticating = false;
            Context context = FlybitsConcierge.this.getContext();
            if (context != null && SharedElementsFactory.INSTANCE.get(context).getSavedJWTToken().isEmpty()) {
                FlybitsConcierge.this.broadcastAuthenticationError(new ConciergeException(exception.getMessage()));
            } else if (context != null && exception.getMessage().contains("Connecting") && FlybitsConcierge.this.isAuthenticated()) {
                FlybitsConcierge.this.broadcastAuthenticationState("authenticated");
            }
            FlybitsConcierge.this.registerNetworkReceiver();
        }
    };

    FlybitsConcierge(Context context) {
        context = context.getApplicationContext();
        this.optedStateChangeListeners = Collections.synchronizedSet(new HashSet());
        this.authenticationStatusListeners = Collections.synchronizedSet(new HashSet());
        this.flybitsViewProviders = Collections.synchronizedMap(new HashMap());
        this.lastProvidedContext = new WeakReference<Context>(context);
        this.commonsDatabase = CommonsDatabase.getDatabase((Context)context);
        this.notificationContentRepository = NotificationContentRepository.Companion.create(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlybitsConcierge with(Context context) {
        if (context == null) {
            throw new NullPointerException("Context cannot be null");
        }
        Class<FlybitsConcierge> clazz = FlybitsConcierge.class;
        synchronized (FlybitsConcierge.class) {
            if (INSTANCE == null) {
                INSTANCE = new FlybitsConcierge(context.getApplicationContext());
                INSTANCE.createNotificationChannel();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return INSTANCE;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            String name = "Concierge Channel";
            String description = "Specific for playing audio content in the concierge.";
            NotificationChannel channel = new NotificationChannel("FLYBITS_CONCIERGE_AUDIO", (CharSequence)name, 4);
            channel.setDescription(description);
            NotificationManager notificationManager = (NotificationManager)this.getContext().getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
        }
    }

    Context getContext() throws ConciergeException {
        if (this.lastProvidedContext != null && this.lastProvidedContext.get() != null) {
            return (Context)this.lastProvidedContext.get();
        }
        throw new ConciergeException("Context is null");
    }

    private FlybitsManager createFlybitsManager() {
        FlybitsManager.Builder builder = new FlybitsManager.Builder(this.getContext()).setAccount(null).setProjectId(this.getConfiguration().getProjectID()).addScope((FlybitsScope)PushScope.SCOPE).addScope((FlybitsScope)KernelScope.SCOPE).addScope((FlybitsScope)new ContextScope(this.currentConfig.getTimeToUploadContext(), TimeUnit.MINUTES));
        return builder.build();
    }

    public void initialize(@IdRes int cfgResource) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.currentConfig = ConciergeConfiguration.createFromXML(this.getContext(), cfgResource);
        String twitterKey = this.currentConfig.getApiKey("key_twitter_consumer");
        String twitterSecret = this.currentConfig.getApiKey("key_twitter_secret");
        if (!TextUtils.isEmpty((CharSequence)twitterKey) && !TextUtils.isEmpty((CharSequence)twitterSecret)) {
            TwitterConfig config = new TwitterConfig.Builder(this.getContext()).logger((com.twitter.sdk.android.core.Logger)new DefaultLogger(3)).twitterAuthConfig(new TwitterAuthConfig(twitterKey, twitterSecret)).debug(true).build();
            Twitter.initialize((TwitterConfig)config);
        }
        this.flybitsManager = this.createFlybitsManager();
        ContentAnalytics contentAnalytics = new ContentAnalytics(this.getContext());
        FlybitsViewPopulator flybitsViewPopulator = new FlybitsViewPopulator(contentAnalytics);
        this.registerFlybitsViewProvider(new EventsViewProvider(flybitsViewPopulator));
        this.registerFlybitsViewProvider(new ImageViewProvider(flybitsViewPopulator));
        this.registerFlybitsViewProvider(new LinksViewProvider(flybitsViewPopulator));
        this.registerFlybitsViewProvider(new OnboardingViewProvider(flybitsViewPopulator));
        this.registerFlybitsViewProvider(new ScheduleViewProvider(flybitsViewPopulator));
        this.registerFlybitsViewProvider(new SurveyViewProvider());
        this.registerFlybitsViewProvider(new TextViewProvider());
        this.registerFlybitsViewProvider(new TwitterViewProvider());
        this.registerFlybitsViewProvider(new VideosViewProvider(flybitsViewPopulator));
        this.registerFlybitsViewProvider(new ArticlesViewProvider(flybitsViewPopulator));
    }

    public void enableDebugMode() {
        FlybitsManager.setDebug();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuthenticationStateListener(@NonNull AuthenticationStatusListener authenticationStatusListener) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            this.authenticationStatusListeners.add(authenticationStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterAuthenticationStateListener(@NonNull AuthenticationStatusListener authenticationStatusListener) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            return this.authenticationStatusListeners.remove(authenticationStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastAuthenticationState(String state) {
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            HashSet<AuthenticationStatusListener> listeners = new HashSet<AuthenticationStatusListener>(this.authenticationStatusListeners);
            for (AuthenticationStatusListener authenticationStatusListener : listeners) {
                switch (state) {
                    case "authenticated": {
                        authenticationStatusListener.onAuthenticated();
                        break;
                    }
                    case "authentication_started": {
                        authenticationStatusListener.onAuthenticationStarted();
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastAuthenticationError(ConciergeException err) {
        Set<AuthenticationStatusListener> set = this.authenticationStatusListeners;
        synchronized (set) {
            HashSet<AuthenticationStatusListener> listeners = new HashSet<AuthenticationStatusListener>(this.authenticationStatusListeners);
            for (AuthenticationStatusListener authenticationStatusListener : listeners) {
                authenticationStatusListener.onAuthenticationError(err);
            }
        }
    }

    public boolean optInLocal() throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (this.isAuthenticating() || !this.isAuthenticated()) {
            return false;
        }
        return this.optInRetryAuthentication();
    }

    private synchronized boolean optInRetryAuthentication() {
        if (!this.isInitialized() || this.idp == null || this.isAuthenticating() || this.isAuthenticated()) {
            return false;
        }
        return this.authenticate(this.idp);
    }

    public void optIn(final @NonNull BasicResultCallback basicResultCallback) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            basicResultCallback.onException(new FlybitsException("Concierge not initialized."));
        } else if (this.isAuthenticating() || !this.isAuthenticated()) {
            basicResultCallback.onException(new FlybitsException("User not authenticated."));
        } else {
            this.flybitsManager.optIn(new BasicResultCallback(){

                public void onSuccess() {
                    FlybitsConcierge.this.broadcastOptedInStateChange(true);
                    basicResultCallback.onSuccess();
                }

                public void onException(@NotNull FlybitsException e) {
                    basicResultCallback.onException(e);
                }
            });
        }
    }

    synchronized boolean retryAuthentication() throws ConciergeUninitializedException {
        if (!this.initialized || this.idp == null || this.authenticating || this.isAuthenticated() || !this.authenticationRequested) {
            return false;
        }
        return this.authenticate(this.idp);
    }

    public synchronized boolean authenticate(@NonNull IDP idp) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        this.idp = idp;
        if (this.isAuthenticated() || this.authenticating) {
            return false;
        }
        this.authenticating = true;
        this.broadcastAuthenticationState("authentication_started");
        this.authenticationRequested = true;
        this.flybitsManager.connect(idp, this.conciergeConnectionResultCallback);
        return true;
    }

    public void logOut(final LogOutCallback logOutCallback) throws ConciergeUninitializedException {
        if (!this.initialized) {
            logOutCallback.onError(new ConciergeUninitializedException());
        } else if (!this.isAuthenticated() || this.authenticating || this.flybitsManager == null) {
            logOutCallback.onError(new ConciergeException("Authentication required before logging out"));
        } else {
            this.flybitsManager.disconnect(new BasicResultCallback(){

                public void onSuccess() {
                    FlybitsConcierge.this.authenticationRequested = false;
                    FlybitsConcierge.this.unregisterNetworkReceiver();
                    if (logOutCallback != null) {
                        logOutCallback.onSuccess();
                    }
                }

                public void onException(@NonNull FlybitsException exception) {
                    if (logOutCallback != null) {
                        logOutCallback.onError(new ConciergeException(exception));
                    }
                }
            });
        }
    }

    public boolean unauthenticateWithoutLogout(FlybitsException e) throws ConciergeUninitializedException {
        if (!this.initialized) {
            throw new ConciergeUninitializedException();
        }
        if (this.authenticating) {
            return false;
        }
        SharedElementsFactory.INSTANCE.get(this.getContext()).setJWTToken("");
        this.authenticationRequested = false;
        this.unregisterNetworkReceiver();
        this.broadcastAuthenticationError(new ConciergeException(e));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOptedStateChangeListener(@NonNull OptedStateChangeListener listener) {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        Set<OptedStateChangeListener> set = this.optedStateChangeListeners;
        synchronized (set) {
            this.optedStateChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOptedStateChangeListener(@NonNull OptedStateChangeListener listener) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        Set<OptedStateChangeListener> set = this.optedStateChangeListeners;
        synchronized (set) {
            this.optedStateChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastOptedInStateChange(boolean optedIn) {
        Set<OptedStateChangeListener> set = this.optedStateChangeListeners;
        synchronized (set) {
            HashSet<OptedStateChangeListener> copy = new HashSet<OptedStateChangeListener>(this.optedStateChangeListeners);
            for (OptedStateChangeListener listener : copy) {
                listener.onOptedStateChange(optedIn);
            }
        }
    }

    public void isOptedIn(final ObjectResultCallback<Boolean> basicResultCallback) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            basicResultCallback.onException(new FlybitsException("Concierge not initialized."));
        } else if (!this.isAuthenticated()) {
            basicResultCallback.onException(new FlybitsException("User not authenticated"));
        } else {
            User.getSelf((Context)this.getContext(), (ObjectResultCallback)new ObjectResultCallback<User>(){

                public void onSuccess(User user) {
                    basicResultCallback.onSuccess((Object)user.isOptedIn());
                }

                public void onException(@NotNull FlybitsException e) {
                    basicResultCallback.onException(e);
                }
            });
        }
    }

    public void isOptedInLocal(ObjectResultCallback<Boolean> basicResultCallback) throws ConciergeException {
        Executors.newSingleThreadExecutor().execute(() -> this.isOptedInLocal(basicResultCallback, new Handler(Looper.getMainLooper())));
    }

    public void isOptedInLocal(ObjectResultCallback<Boolean> basicResultCallback, Handler handler) throws ConciergeException {
        if (!this.isInitialized()) {
            handler.post(() -> basicResultCallback.onException(new FlybitsException("Concierge not initialized.")));
        } else if (!this.isAuthenticated()) {
            handler.post(() -> basicResultCallback.onException(new FlybitsException("User not authenticated")));
        } else {
            Context context = this.getContext();
            if (context != null) {
                User user = this.commonsDatabase.userDao().getSingle();
                handler.post(() -> {
                    if (user == null) {
                        basicResultCallback.onException(new FlybitsException("User not present, make sure you're authenticated."));
                    } else {
                        basicResultCallback.onSuccess((Object)user.isOptedIn());
                    }
                });
            } else {
                handler.post(() -> basicResultCallback.onException(new FlybitsException("Context null")));
            }
        }
    }

    public void optOut(final @NonNull BasicResultCallback callback) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            callback.onException(new FlybitsException("Concierge uninitialized. Call initialize()"));
        } else if (!this.isAuthenticated() || this.isAuthenticating() || this.flybitsManager == null) {
            callback.onException(new FlybitsException("User unauthenticated. Call authenticate()"));
        } else {
            this.flybitsManager.optOut(new BasicResultCallback(){

                public void onSuccess() {
                    FlybitsConcierge.this.broadcastOptedInStateChange(false);
                    Context context = FlybitsConcierge.this.getContext();
                    if (context != null) {
                        InternalPreferences.saveSurveyDone(context, false);
                        InternalPreferences.saveOnBoardingDone(context, false);
                    }
                    callback.onSuccess();
                }

                public void onException(@NotNull FlybitsException e) {
                    callback.onException(e);
                }
            });
        }
    }

    private boolean unregisterNetworkReceiver() {
        if (this.networkReceiverRegistered) {
            try {
                this.getContext().unregisterReceiver(this.networkReceiver);
                this.networkReceiverRegistered = false;
                return true;
            }
            catch (Exception e) {
                Logger.exception((String)"FlybitsConcierge.unregisterNetworkReceiver()", (Exception)e);
                return false;
            }
        }
        return false;
    }

    private boolean registerNetworkReceiver() {
        if (!this.networkReceiverRegistered && this.isAutoRetryAuthenticationOnConnectedEnabled()) {
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            try {
                this.getContext().registerReceiver(this.networkReceiver, intentFilter);
                this.networkReceiverRegistered = true;
                return true;
            }
            catch (Exception e) {
                Logger.exception((String)"FlybitsConcierge.registerNetworkReceiver()", (Exception)e);
                return false;
            }
        }
        return false;
    }

    public void show(ShowMode mode) throws ConciergeException {
        Context context = this.getContext();
        Intent activityIntent = null;
        switch (mode) {
            case NEW_ACTIVITY: {
                activityIntent = new Intent(context, ConciergeActivity.class);
                break;
            }
            case OVERLAY: {
                activityIntent = new Intent(context, ConciergePopupActivity.class);
                break;
            }
            case EXTERNAL: {
                break;
            }
            default: {
                throw new ConciergeException("Invalid ShowMode, use NEW_ACTIVITY or OVERLAY.");
            }
        }
        activityIntent.setFlags(0x10000000);
        context.startActivity(activityIntent);
    }

    public void showPush(ShowMode mode, Push push) throws ConciergeException {
        Intent intent = this.getShowPushIntent(mode, push);
        if (intent != null) {
            this.getContext().startActivity(intent);
        }
    }

    @Nullable
    public Intent getShowPushIntent(ShowMode mode, Push push) throws ConciergeException {
        Intent intent;
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        Context context = this.getContext();
        boolean isViewablePush = this.notificationContentRepository.getContentId(push) != null || this.notificationContentRepository.getUrl(push) != null;
        switch (mode) {
            case NEW_ACTIVITY: {
                intent = new Intent(context, ConciergeActivity.class);
                intent.setFlags(0x10000000);
                if (!isViewablePush) break;
                intent.putExtra("flybits_con_push_extra", (Parcelable)push);
                break;
            }
            case OVERLAY: {
                intent = new Intent(context, ConciergePopupActivity.class);
                intent.setFlags(0x10000000);
                if (!isViewablePush) break;
                intent.putExtra("flybits_con_push_extra", (Parcelable)push);
                break;
            }
            case EXTERNAL: {
                if (isViewablePush) {
                    intent = new Intent(context, NotificationsActivity.class);
                    intent.setFlags(0x10000000);
                    intent.putExtra("flybits_con_push_extra", (Parcelable)push);
                    break;
                }
                intent = null;
                break;
            }
            default: {
                throw new ConciergeException("Invalid ShowMode, use NEW_ACTIVITY, OVERLAY, or EXTERNAL.");
            }
        }
        return intent;
    }

    public void setAutoRetryAuthenticationOnConnected(boolean enabled) throws ConciergeUninitializedException {
        if (!this.initialized) {
            throw new ConciergeUninitializedException();
        }
        InternalPreferences.setAutoRetryAuthOnConnected(this.getContext(), enabled);
    }

    public boolean isAutoRetryAuthenticationOnConnectedEnabled() throws ConciergeUninitializedException {
        if (this.initialized) {
            return InternalPreferences.isAutoRetryAuthOnConnectedEnabled(this.getContext());
        }
        throw new ConciergeUninitializedException();
    }

    public ConciergeConfiguration getConfiguration() {
        return this.currentConfig;
    }

    public void enablePushMessaging(String token) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (!this.isAuthenticated()) {
            InternalPreferences.savePushToken(this.getContext(), token);
            Logger.setTag((String)FlybitsConcierge.class.getSimpleName()).d("enablePushMessaging() not authenticated, saving token locally");
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            PushManager.enablePush((Context)this.getContext(), (String)token, new HashMap(), null, (Handler)handler);
            Logger.setTag((String)FlybitsConcierge.class.getSimpleName()).d("enablePushMessaging() push enabled");
        }
    }

    private boolean enablePushMessagingUsingLocalToken() {
        Handler handler = new Handler(Looper.getMainLooper());
        String token = InternalPreferences.pushToken(this.getContext());
        if (token != null) {
            PushManager.enablePush((Context)this.getContext(), (String)token, new HashMap(), null, (Handler)handler);
            return true;
        }
        return false;
    }

    public boolean isAuthenticated() throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        return !SharedElementsFactory.INSTANCE.get(this.getContext()).getSavedJWTToken().isEmpty();
    }

    public boolean isAuthenticating() throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        return this.authenticating;
    }

    public boolean preloadContent() throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        if (!this.isAuthenticated()) {
            return false;
        }
        WorkManager workManager = WorkManager.getInstance();
        Constraints workConstraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PreloadingWorker.class).setConstraints(workConstraints)).build();
        workManager.enqueue(workRequest);
        return true;
    }

    public void registerFlybitsViewProvider(FlybitsViewProvider flybitsViewProvider) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        this.flybitsViewProviders.put(flybitsViewProvider.getContentType(), flybitsViewProvider);
    }

    @Override
    public Collection<FlybitsViewProvider> getFlybitsViewProviders() throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        return this.flybitsViewProviders.values();
    }

    @Override
    @Nullable
    public FlybitsViewProvider getFlybitsViewProvider(String contentType) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        return this.flybitsViewProviders.get(contentType);
    }

    public void startContextPlugin(FlybitsContextPlugin contextPlugin) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        ContextManager.start((Context)this.getContext(), (FlybitsContextPlugin)contextPlugin);
    }

    public void stopContextPlugin(FlybitsContextPlugin contextPlugin) throws ConciergeUninitializedException {
        if (!this.isInitialized()) {
            throw new ConciergeUninitializedException();
        }
        ContextManager.stop((Context)this.getContext(), (FlybitsContextPlugin)contextPlugin);
    }
}

