package com.flybits.concierge.viewmodels;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.support.annotation.NonNull;

import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.concierge.FlybitsConcierge;

public class SettingsViewModel extends AndroidViewModel {

    private FlybitsConcierge flybitsConcierge;

    public SettingsViewModel(@NonNull Application application) {
        super(application);
        this.flybitsConcierge = FlybitsConcierge.with(application);
    }

    public void optOutFlybits(final BasicResultCallback basicResultCallback){
        flybitsConcierge.optOut(new BasicResultCallback() {
            @Override
            public void onSuccess() {
                basicResultCallback.onSuccess();
            }

            @Override
            public void onException(FlybitsException e) {
                basicResultCallback.onException(e);
            }
        });
    }
}
