package com.flybits.concierge.viewmodels

import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.ViewModel
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.concierge.FlybitsConcierge

class OptInViewModel(private val flybitsConcierge: FlybitsConcierge): ViewModel() {

    data class OptInResult(val success: Boolean, val error: FlybitsException? = null)
    data class Span(val startIndex: Int, val endIndex: Int, val text: String)

    val footerSpan: LiveData<Span> = MutableLiveData()
    val checkboxState: LiveData<Boolean> = MutableLiveData()

    init {
        val termsAndConditionsText = "Flybits Terms and Conditions"
        val text = "By selecting to opt in to concierge and pressing continue you are agreeing to the $termsAndConditionsText"
        val startIndex = text.length-termsAndConditionsText.length
        (footerSpan as MutableLiveData).postValue(
                Span(startIndex, text.length, text)
        )

        (checkboxState as MutableLiveData).postValue(false)
    }

    fun checkboxSelected() {
        (checkboxState as MutableLiveData).postValue(checkboxState.value?.not())
    }

    fun optIn(): LiveData<OptInResult> {
        val liveData = MutableLiveData<OptInResult>()
        flybitsConcierge.optIn(object: BasicResultCallback {
            override fun onException(exception: FlybitsException) {
                liveData.postValue(OptInResult(false, exception))
            }

            override fun onSuccess() {
                liveData.postValue(OptInResult(true))
            }
        })
        return liveData
    }

}