package com.flybits.concierge.activities

import android.content.Intent
import android.support.v4.app.Fragment
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.R
import com.flybits.concierge.fragments.PrivacyPolicyFragment
import com.flybits.concierge.fragments.TermsAndServicesFragment

/**
 * This activity is responsible for displaying either the Terms of Service or Privacy Policy.
 */
class DocumentActivity: SingleFragmentActivity() {

    companion object {
        const val EXTRA_DOCUMENT_TYPE = "flybits_con_extra_document_type"
        const val DOCUMENT_TYPE_PRIVACY_POLICY = "flybits_con_document_type_privacy_policy"
        const val DOCUMENT_TYPE_TOS= "flybits_con_document_type_terms_of_service"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        val type: String = intent.extras.getString(EXTRA_DOCUMENT_TYPE, DOCUMENT_TYPE_PRIVACY_POLICY)
        return when (type){
            DOCUMENT_TYPE_PRIVACY_POLICY -> {
                supportActionBar?.title = resources.getString(R.string.flybits_con_settings_privacy_policy)
                PrivacyPolicyFragment.newInstance()
            }
            DOCUMENT_TYPE_TOS -> {
                supportActionBar?.title = resources.getString(R.string.flybits_con_settings_terms_of_service)
                TermsAndServicesFragment.newInstance(true)
            }
            else -> {
                val e = FlybitsException("Invalid document type found")
                Logger.exception("DocumentActivity.onCreateSingleContentActivity", e)
                throw e
            }
        }
    }
}