package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;

import com.flybits.concierge.ConciergeConstants;
import com.flybits.concierge.ConciergeFragment;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.R;

public class TermsAndServicesFragment extends Fragment {

    private final static String FLAG_VIEWING_ONLY = "viewing_only";

    private WebView webBody;
    private CheckBox chkAccept;
    private Button btnDecline, btnAccept;
    private Context currentContext;
    private ConciergeFragment parentFragment;
    private View loadView;
    private View errorView;
    private View errorRetryButton;
    private View buttonHolder;
    private String tncURL = "";
    private boolean viewingOnly = false;
    private boolean errorPresent = false;
    private boolean loading = false;

    public static TermsAndServicesFragment newInstance(boolean viewingOnly) {
        TermsAndServicesFragment termsAndServicesFragment = new TermsAndServicesFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean(FLAG_VIEWING_ONLY,viewingOnly);
        termsAndServicesFragment.setArguments(bundle);
        return termsAndServicesFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        currentContext = context;
        parentFragment = (ConciergeFragment) getParentFragment();
    }

    @Override
    public void setArguments(@Nullable Bundle args) {
        if (args != null){
            this.viewingOnly = args.getBoolean(FLAG_VIEWING_ONLY);
        }
        super.setArguments(args);
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.flybits_con_fragment_tnc, container, false);
        return v;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        webBody = view.findViewById(R.id.flybits_con_fragment_tnc_webBody);
        chkAccept = view.findViewById(R.id.flybits_con_fragment_tnc_chkAccept);
        btnDecline = view.findViewById(R.id.flybits_con_fragment_tnc_btnDecline);
        btnAccept = view.findViewById(R.id.flybits_con_fragment_tnc_btnAccept);
        loadView = view.findViewById(R.id.flybits_con_tnc_fragment_prgLoading);
        errorView = view.findViewById(R.id.flybits_con_fragment_tnc_error_holder);
        errorRetryButton = view.findViewById(R.id.offline_fragment_retry_button);
        buttonHolder = view.findViewById(R.id.flybits_con_tnc_button_holder);

        errorRetryButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                loadWebView(tncURL);
            }
        });

        if (viewingOnly){
            btnDecline.setVisibility(View.GONE);
            btnAccept.setVisibility(View.GONE);
            chkAccept.setVisibility(View.GONE);
        }

        if (savedInstanceState == null) {
            tncURL = FlybitsConcierge.with(getActivity()).getConfiguration().getTNCUrl();
            if (tncURL != null){
                loadWebView(tncURL);
            }
        } else {
            loading = savedInstanceState.getBoolean(ConciergeConstants.STATE_LOADING);
            tncURL = savedInstanceState.getString(ConciergeConstants.STATE_URL);
            //If the view got rotated while loading was in progress, do not restore web view
            if (loading){
                loading = false;
                loadWebView(tncURL);
            }else{
                webBody.restoreState(savedInstanceState);
                chkAccept.setChecked(savedInstanceState.getBoolean("checkbox"));
                errorPresent = savedInstanceState.getBoolean(ConciergeConstants.STATE_ERROR_PRESENT);
                if (errorPresent){
                    errorView.setVisibility(View.VISIBLE);
                    webBody.setVisibility(View.GONE);
                    buttonHolder.setVisibility(View.GONE);
                }else{
                    errorView.setVisibility(View.GONE);
                    webBody.setVisibility(View.VISIBLE);
                    buttonHolder.setVisibility(View.VISIBLE);
                }
            }
        }

        btnAccept.setEnabled(chkAccept.isChecked());

        btnDecline.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                parentFragment.childMessage(ConciergeFragment.MESSAGE_TNC, false);
            }
        });

        btnAccept.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                InternalPreferences.saveTNCAccepted(currentContext, true);
                parentFragment.childMessage(ConciergeFragment.MESSAGE_TNC, true);
            }
        });

        chkAccept.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                btnAccept.setEnabled(b);
            }
        });

    }

    private void loadWebView(String tncURL){
        if (loading) return;

        loading = true;
        errorPresent = false;
        webBody.loadUrl(tncURL);
        loadView.setVisibility(View.VISIBLE);
        webBody.setVisibility(View.GONE);
        chkAccept.setClickable(false); //Do not allow for accept until terms have loaded and are viewable
        webBody.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
        webBody.setWebViewClient(new WebViewClient(){
            @Override
            public void onPageFinished(WebView view, String url) {
                loading = false;
                loadView.setVisibility(View.GONE);
                if (errorPresent){
                    buttonHolder.setVisibility(View.GONE);
                    webBody.setVisibility(View.GONE);
                    errorView.setVisibility(View.VISIBLE);
                }else{
                    errorView.setVisibility(View.VISIBLE);
                    buttonHolder.setVisibility(View.VISIBLE);
                    webBody.setVisibility(View.VISIBLE);
                    chkAccept.setClickable(true);
                }
                super.onPageFinished(view, url);
            }

            @Override
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                errorPresent = true;
                super.onReceivedError(view, request, error);
            }
        });
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        webBody.saveState(outState);
        outState.putBoolean(ConciergeConstants.STATE_LOADING,loading);
        outState.putBoolean(ConciergeConstants.STATE_ERROR_PRESENT,errorPresent);
        outState.putBoolean("checkbox", chkAccept.isChecked());
        outState.putString(ConciergeConstants.STATE_URL,tncURL);
    }
}
