package com.flybits.concierge.viewmodels;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.support.annotation.NonNull;

import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.OptOutCallback;
import com.flybits.concierge.exception.ConciergeException;

public class SettingsViewModel extends AndroidViewModel {

    private FlybitsConcierge flybitsConcierge;

    public SettingsViewModel(@NonNull Application application) {
        super(application);
        this.flybitsConcierge = FlybitsConcierge.with(application);
    }

    public void optOutFlybits(final OptOutCallback optOutCallback){
        flybitsConcierge.optOut(new OptOutCallback() {
            @Override
            public void onSuccess() {
                optOutCallback.onSuccess();
            }

            @Override
            public void onError(ConciergeException e) {
                optOutCallback.onError(e);
            }
        });
    }
}
