package com.flybits.concierge.services

import android.app.PendingIntent
import android.content.Intent
import com.flybits.android.push.models.Push

/**
 * Used for creating [PendingIntent] and [Intent] during the creation of flybits push notifications.
 */
interface ConciergeIntentCreator {

    /**
     * This method will be invoked right before a push notification is passed off to the
     * NotificationManager for display to the user. Its purpose is to allow the developer
     * to pass whatever data they need to the [Intent], and return a [PendingIntent]
     * that will be stored in the notification being sent.
     *
     * If you only need to change the [Intent] creation behaviour and not the [PendingIntent]
     * creation behaviour then override `onCreateIntent(push: Push)` instead.
     *
     * @param intent An already created intent that contains [Push] under the
     * ConciergeConstants.PUSH_EXTRA key, and by default uses the applications
     * launcher activity.
     *
     * @param push [Push] associated to the notification being shown to the user.
     */
    fun onCreatePendingIntent(intent: Intent, push: Push): PendingIntent

    /**
     * This method will be invoked right before a push notification is passed off to the
     * NotificationManager for display to the user. Its purpose is to allow the developer
     * to pass whatever data they need to the [Intent] that will be stored in the [PendingIntent].
     *
     * To override the default [PendingIntent] override `onCreatePendingIntent(intent: Intent, push: Push)`
     *
     * @param push [Push] tied to the notification being currently created.
     *
     * @return [Intent] stored within the [PendingIntent] associated to the notification being
     * shown to the user.
     */
    fun onCreateIntent(push: Push): Intent
}