package com.flybits.concierge.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.LocalizedValue;

public class Audio extends BaseTemplate implements Parcelable
{
    public String _id;
    public LocalizedValue title;
    public LocalizedValue description;
    public String duration;
    public String sourceURL;
    public String imageURL;

    public Audio()
    {

    }

    protected Audio(Parcel in) {
        super(in);
        _id = in.readString();
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        description = in.readParcelable(LocalizedValue.class.getClassLoader());
        duration = in.readString();
        sourceURL = in.readString();
        imageURL = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest,flags);
        dest.writeString(_id);
        dest.writeParcelable(title, flags);
        dest.writeParcelable(description, flags);
        dest.writeString(duration);
        dest.writeString(sourceURL);
        dest.writeString(imageURL);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Audio> CREATOR = new Creator<Audio>() {
        @Override
        public Audio createFromParcel(Parcel in) {
            return new Audio(in);
        }

        @Override
        public Audio[] newArray(int size) {
            return new Audio[size];
        }
    };
}
