package com.flybits.concierge;

import android.support.annotation.Nullable;

import java.util.Collection;

/**
 * Responsible for retrieving {@Link FlybitsViewProvider}'s that have been registered
 * in the {@link FlybitsConcierge}.
 */
public interface FlybitsViewProviderGetter {

    /**
     * Get list of registered {@link FlybitsViewProvider}s.
     *
     * @return List of registered {@link FlybitsViewProvider}s.
     */
    @Nullable
    Collection<FlybitsViewProvider> getFlybitsViewProviders();

    /**
     * Retrieve {@link FlybitsViewProvider} for a specific content-type.
     *
     * @param contentType Content-type of the {@link FlybitsViewProvider} to be retrieved.
     * @return Retrieved FlybitsViewProvider, null if content-type was not registered.
     */
    @Nullable
    FlybitsViewProvider getFlybitsViewProvider(String contentType);
}
