package com.flybits.concierge.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import com.flybits.android.kernel.reservedtemplates.survey.models.QuestionChoice;
import com.flybits.concierge.R;

import java.util.ArrayList;
import java.util.List;

public class SurveyMultipleChoice extends SurveyBaseView
{
    private int choice;
    private List<QuestionChoice> choices;
    private List<RadioButton> radios;

    public SurveyMultipleChoice(Context context, List<QuestionChoice> choices, int choice)
    {
        super(context);
        this.choices = choices;
        this.choice = choice;
        init(null, 0);
    }

    public SurveyMultipleChoice(Context context)
    {
        super(context);
        init(null, 0);
    }

    public SurveyMultipleChoice(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        init(attrs, 0);
    }

    public SurveyMultipleChoice(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle)
    {
        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = inflater.inflate(R.layout.flybits_con_view_survey_multiple_choice, this, true);

        RadioGroup radioGroup = view.findViewById(R.id.flybits_con_view_survey_multiple_choice_lytRadioGroup);

        radios = new ArrayList<>();
        CompoundButton.OnCheckedChangeListener checkChangedListener = new CompoundButton.OnCheckedChangeListener()
        {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked)
            {
                for (RadioButton btn : radios)
                {
                    btn.setChecked(false);
                }

                if (isChecked)
                {
                    buttonView.setChecked(true);
                }

                callOnClick();
            }
        };

        for (int i = 0; i < choices.size(); i++)
        {
            QuestionChoice choice = choices.get(i);
            RadioButton button = (RadioButton) inflater.inflate(R.layout.flybits_con_view_survey_radio, radioGroup, false);

            radios.add(button);
            button.setOnCheckedChangeListener(checkChangedListener);
            button.setText(choice.value.getValue());
            button.setId(i + 100);
            radioGroup.addView(button);
            button.setChecked(i == this.choice);
        }
    }

    @Override
    public Object getAnswer()
    {
        for (int i = 0; i < radios.size(); i++)
        {
            if (radios.get(i).isChecked())
            {
                return i;
            }
        }

        return null;
    }
}
