package com.flybits.concierge.models

import com.beust.klaxon.Klaxon
import com.flybits.commons.library.models.JsonParser
import org.json.JSONObject

data class CategorySettings(var categories: List<Category> = emptyList()): JsonParser {

    override fun toJson(): JSONObject {
        return JSONObject(Klaxon().toJsonString(this))
    }

    override fun fromJson(json: String?) {
        if (json != null){
            val categorySettings = Klaxon().parse<CategorySettings>(json)
            this.categories = categorySettings?.categories ?: emptyList()
        }
    }

}