package com.flybits.concierge.fragments;


import android.arch.lifecycle.ViewModelProviders;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.VideoView;

import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.viewmodels.VideoViewModel;

public class VideoFragment extends Fragment
{
    private static final String ARG_VIDEO = "flybits_con_arg_video";
    private static final String ARG_URL = "flybits_con_arg_url";

    private String title;
    private String url;
    private VideoViewModel viewModel;
    private VideoView videoView;

    public VideoFragment()
    {
        // Required empty public constructor
    }

    public static VideoFragment newInstance(Video video)
    {
        VideoFragment fragment = new VideoFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_VIDEO, video);
        fragment.setArguments(args);
        return fragment;
    }

    public static VideoFragment newInstance(String video)
    {
        VideoFragment fragment = new VideoFragment();
        Bundle args = new Bundle();
        args.putString(ARG_URL, video);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (getArguments() != null)
        {
            Video video = getArguments().getParcelable(ARG_VIDEO);
            if (video != null)
            {
                title = video.title.getValue();
                url = video.url;
            }
            else
            {
                title = getString(R.string.flybits_con_content_video);
                url = getArguments().getString(ARG_URL);
            }
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_video, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        viewModel = ViewModelProviders.of(this).get(VideoViewModel.class);

        videoView = view.findViewById(R.id.flybits_con_fragment_video_viewVideo);
        TextView titleView = view.findViewById(R.id.flybits_con_fragment_video_txtTitle);
        titleView.setText(title);

        MediaController mediaController = new MediaController(getContext());
        mediaController.setAnchorView(videoView);

        Uri videoUri = Uri.parse(url);
        videoView.setMediaController(mediaController);
        videoView.setVideoURI(videoUri);
        videoView.requestFocus();
        videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener()
        {

            public void onPrepared(MediaPlayer mp)
            {
                videoView.seekTo(viewModel.getSeekPosition());
                videoView.start();
            }
        });

        videoView.setOnErrorListener(new MediaPlayer.OnErrorListener()
        {
            @Override
            public boolean onError(MediaPlayer mp, int what, int extra)
            {
                new MaterialDialog.Builder(getActivity())
                        .title(R.string.flybits_con_video_fragment_error_title)
                        .content(R.string.flybits_con_video_fragment_error_message)
                        .positiveText(R.string.flybits_con_ok)
                        .show();
                getFragmentManager().popBackStack();

                return true;
            }
        });
    }

    @Override
    public void onStop()
    {
        super.onStop();
        viewModel.setSeekPosition(videoView.getCurrentPosition());
    }
}
