/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.repository.push;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.push.models.Push;
import com.flybits.android.push.utils.PushQueryParameters;
import com.flybits.android.push.utils.SortOrder;
import com.flybits.commons.library.api.results.callbacks.ListResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.NotificationContent;
import com.flybits.concierge.repository.ModelConverter;
import com.flybits.concierge.repository.RepositoryResponse;
import com.flybits.concierge.repository.content.ContentGetter;
import com.flybits.concierge.repository.push.NotificationContentRepository;
import com.flybits.concierge.repository.push.PushGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0010\b\u0002\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J8\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u000b0\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u00010\u0010J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/flybits/concierge/repository/push/NotificationContentRepository;", "", "pushGetter", "Lcom/flybits/concierge/repository/push/PushGetter;", "contentGetter", "Lcom/flybits/concierge/repository/content/ContentGetter;", "modelConverter", "Lcom/flybits/concierge/repository/ModelConverter;", "(Lcom/flybits/concierge/repository/push/PushGetter;Lcom/flybits/concierge/repository/content/ContentGetter;Lcom/flybits/concierge/repository/ModelConverter;)V", "getBaseTemplate", "Landroid/arch/lifecycle/LiveData;", "Lcom/flybits/concierge/repository/RepositoryResponse;", "Lcom/flybits/concierge/models/BaseTemplate;", "contentId", "", "callback", "Lcom/flybits/commons/library/api/results/callbacks/ObjectResultCallback;", "getContentId", "push", "Lcom/flybits/android/push/models/Push;", "getNotificationContentRemote", "", "Lcom/flybits/concierge/models/NotificationContent;", "daysOld", "", "getUrl", "Companion", "concierge_release"})
public final class NotificationContentRepository {
    private final PushGetter pushGetter;
    private final ContentGetter contentGetter;
    private final ModelConverter modelConverter;
    private static final String JSON_KEY_URL = "url";
    private static final String JSON_KEY_VALUE = "value";
    private static final String JSON_KEY_CONTENT = "contentId";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final LiveData<RepositoryResponse<List<NotificationContent>>> getNotificationContentRemote(int daysOld, @Nullable ObjectResultCallback<List<NotificationContent>> callback) {
        PushQueryParameters params;
        MutableLiveData liveData = new MutableLiveData();
        long timeNow = System.currentTimeMillis() / (long)1000;
        long fromTime = timeNow - (long)(daysOld * 24 * 60 * 60);
        PushQueryParameters pushQueryParameters = params = ((PushQueryParameters.Builder)new PushQueryParameters.Builder().setSortOrder(SortOrder.DESCENDING).addTimeRange(fromTime, timeNow).setPaging(20L, 0L)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)pushQueryParameters, (String)"params");
        this.pushGetter.getPush(pushQueryParameters, (PagedResultCallback<Push>)((PagedResultCallback)new PagedResultCallback<Push>(this, liveData, callback){
            final /* synthetic */ NotificationContentRepository this$0;
            final /* synthetic */ MutableLiveData $liveData;
            final /* synthetic */ ObjectResultCallback $callback;

            public void onSuccess(@Nullable ArrayList<Push> items) {
                Sequence contentIds2;
                Logger.d((String)("NotificationContentRepository: got items=" + items));
                Object object = items;
                if (object == null || (object = CollectionsKt.asSequence((Iterable)((Iterable)object))) == null || (object = SequencesKt.map((Sequence)object, (Function1)getNotificationContentRemote.onSuccess.contentIds.1.INSTANCE)) == null || (object = SequencesKt.filterNotNull((Sequence)object)) == null || (object = SequencesKt.toList((Sequence)object)) == null) {
                    object = contentIds2 = CollectionsKt.emptyList();
                }
                if (contentIds2.isEmpty()) {
                    List response = CollectionsKt.emptyList();
                    this.$liveData.setValue(new RepositoryResponse<T>(response, null, 2, null));
                    ObjectResultCallback objectResultCallback = this.$callback;
                    if (objectResultCallback != null) {
                        objectResultCallback.onSuccess((Object)response);
                    }
                    return;
                }
                NotificationContentRepository.access$getContentGetter$p(this.this$0).getContent((Collection)contentIds2, (ListResultCallback<Content>)((ListResultCallback)new ListResultCallback<Content>(this, (List)contentIds2){
                    final /* synthetic */ getNotificationContentRemote.1 this$0;
                    final /* synthetic */ List $contentIds;

                    /*
                     * WARNING - void declaration
                     */
                    public void onSuccess(@Nullable ArrayList<Content> items) {
                        block9: {
                            void $receiver$iv$iv;
                            Iterable $receiver$iv;
                            Logger.d((String)("NotificationContentRepository: got content=" + items));
                            Iterable iterable = $receiver$iv = (Iterable)this.$contentIds;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (T item$iv$iv : $receiver$iv$iv) {
                                NotificationContent notificationContent;
                                Content content;
                                Content content2;
                                Iterable iterable2;
                                String string2 = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                ArrayList<Content> arrayList = items;
                                if (arrayList != null) {
                                    Object v1;
                                    block8: {
                                        Iterable iterable3 = arrayList;
                                        iterable2 = iterable3;
                                        Iterator<T> iterator = iterable2.iterator();
                                        while (iterator.hasNext()) {
                                            void contentId;
                                            T t = iterator.next();
                                            Content it = (Content)t;
                                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)contentId)) continue;
                                            v1 = t;
                                            break block8;
                                        }
                                        v1 = null;
                                    }
                                    content2 = v1;
                                } else {
                                    content2 = content = null;
                                }
                                if (content != null) {
                                    BaseTemplate baseTemplate = NotificationContentRepository.access$getModelConverter$p(this.this$0.this$0).contentToBaseTemplate(content);
                                    Logger.d((String)("NotificationContentRepository: base template converted=" + baseTemplate));
                                    if (baseTemplate != null) {
                                        Iterable baseTemplateNonNull = iterable2;
                                        notificationContent = new NotificationContent((BaseTemplate)((Object)baseTemplateNonNull), 0L);
                                    } else {
                                        notificationContent = null;
                                    }
                                } else {
                                    notificationContent = null;
                                }
                                NotificationContent notificationContent2 = notificationContent;
                                collection.add(notificationContent2);
                            }
                            List notificationContent = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
                            this.this$0.$liveData.setValue(new RepositoryResponse<T>(notificationContent, null, 2, null));
                            ObjectResultCallback objectResultCallback = this.this$0.$callback;
                            if (objectResultCallback == null) break block9;
                            objectResultCallback.onSuccess((Object)notificationContent);
                        }
                    }

                    public void onException(@Nullable FlybitsException exception) {
                        block0: {
                            Logger.d((String)("NotificationContentRepository: exception=" + (Object)((Object)exception)));
                            this.this$0.$liveData.setValue(new RepositoryResponse<T>(null, exception, 1, null));
                            ObjectResultCallback objectResultCallback = this.this$0.$callback;
                            if (objectResultCallback == null) break block0;
                            objectResultCallback.onException(exception);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$contentIds = $captured_local_variable$1;
                    }
                }));
            }

            public void onLoadedAllItems() {
            }

            public void onException(@Nullable FlybitsException exception) {
                block0: {
                    FlybitsException flybitsException = exception;
                    Logger.d((String)("NotificationContentRepository: exception=" + (flybitsException != null ? flybitsException.getMessage() : null)));
                    this.$liveData.setValue(new RepositoryResponse<T>(null, exception, 1, null));
                    ObjectResultCallback objectResultCallback = this.$callback;
                    if (objectResultCallback == null) break block0;
                    objectResultCallback.onException(exception);
                }
            }
            {
                this.this$0 = $outer;
                this.$liveData = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        }));
        return (LiveData)liveData;
    }

    @NotNull
    public static /* synthetic */ LiveData getNotificationContentRemote$default(NotificationContentRepository notificationContentRepository, int n, ObjectResultCallback objectResultCallback, int n2, Object object) {
        if ((n2 & 2) != 0) {
            objectResultCallback = null;
        }
        return notificationContentRepository.getNotificationContentRemote(n, (ObjectResultCallback<List<NotificationContent>>)objectResultCallback);
    }

    @Nullable
    public final String getContentId(@NotNull Push push) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        try {
            JSONObject jsonObject = new JSONObject(push.getCustomFieldsAsString());
            string2 = jsonObject.getJSONObject(JSON_KEY_CONTENT).getString(JSON_KEY_VALUE);
        }
        catch (Exception e) {
            string2 = null;
        }
        return string2;
    }

    @Nullable
    public final String getUrl(@NotNull Push push) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)push, (String)"push");
        try {
            JSONObject jsonObject = new JSONObject(push.getCustomFieldsAsString());
            string2 = jsonObject.getString(JSON_KEY_URL);
        }
        catch (Exception e) {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final LiveData<RepositoryResponse<BaseTemplate>> getBaseTemplate(@NotNull String contentId, @Nullable ObjectResultCallback<BaseTemplate> callback) {
        Intrinsics.checkParameterIsNotNull((Object)contentId, (String)JSON_KEY_CONTENT);
        MutableLiveData liveData = new MutableLiveData();
        this.contentGetter.getContent(contentId, (ObjectResultCallback<Content>)((ObjectResultCallback)new ObjectResultCallback<Content>(this, liveData, callback){
            final /* synthetic */ NotificationContentRepository this$0;
            final /* synthetic */ MutableLiveData $liveData;
            final /* synthetic */ ObjectResultCallback $callback;

            public void onSuccess(@NotNull Content item) {
                block1: {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                        BaseTemplate baseTemplate = NotificationContentRepository.access$getModelConverter$p(this.this$0).contentToBaseTemplate(item);
                        if (baseTemplate == null) break block0;
                        this.$liveData.setValue(new RepositoryResponse<BaseTemplate>(baseTemplate, null));
                        ObjectResultCallback objectResultCallback = this.$callback;
                        if (objectResultCallback == null) break block1;
                        objectResultCallback.onSuccess((Object)baseTemplate);
                        break block1;
                    }
                    FlybitsException exception = new FlybitsException("Unable to covert content to base template");
                    this.$liveData.setValue(new RepositoryResponse<Object>(null, exception));
                    ObjectResultCallback objectResultCallback = this.$callback;
                    if (objectResultCallback == null) break block1;
                    objectResultCallback.onException(exception);
                }
            }

            public void onException(@NotNull FlybitsException e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
                    this.$liveData.setValue(new RepositoryResponse<Object>(null, e));
                    ObjectResultCallback objectResultCallback = this.$callback;
                    if (objectResultCallback == null) break block0;
                    objectResultCallback.onException(e);
                }
            }
            {
                this.this$0 = $outer;
                this.$liveData = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        }));
        return (LiveData)liveData;
    }

    @NotNull
    public static /* synthetic */ LiveData getBaseTemplate$default(NotificationContentRepository notificationContentRepository, String string2, ObjectResultCallback objectResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            objectResultCallback = null;
        }
        return notificationContentRepository.getBaseTemplate(string2, (ObjectResultCallback<BaseTemplate>)objectResultCallback);
    }

    public NotificationContentRepository(@NotNull PushGetter pushGetter, @NotNull ContentGetter contentGetter, @NotNull ModelConverter modelConverter) {
        Intrinsics.checkParameterIsNotNull((Object)pushGetter, (String)"pushGetter");
        Intrinsics.checkParameterIsNotNull((Object)contentGetter, (String)"contentGetter");
        Intrinsics.checkParameterIsNotNull((Object)modelConverter, (String)"modelConverter");
        this.pushGetter = pushGetter;
        this.contentGetter = contentGetter;
        this.modelConverter = modelConverter;
    }

    @NotNull
    public static final /* synthetic */ ContentGetter access$getContentGetter$p(NotificationContentRepository $this) {
        return $this.contentGetter;
    }

    @NotNull
    public static final /* synthetic */ ModelConverter access$getModelConverter$p(NotificationContentRepository $this) {
        return $this.modelConverter;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/flybits/concierge/repository/push/NotificationContentRepository$Companion;", "", "()V", "JSON_KEY_CONTENT", "", "JSON_KEY_URL", "JSON_KEY_VALUE", "concierge_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

