package com.flybits.concierge.models

import android.arch.persistence.room.ColumnInfo
import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey
import android.os.Parcelable
import kotlinx.android.parcel.Parcelize

@Entity(tableName = Category.TABLE_NAME)
@Parcelize
data class Category(@PrimaryKey(autoGenerate = true) @ColumnInfo(name = COLUMN_ID) var id: Long? = null
                    , @ColumnInfo(name = COLUMN_NAME) var name: String
                    , @ColumnInfo(name = COLUMN_LABELS) var labels: Set<String> = setOf(name)): Parcelable{

    companion object {
        const val TABLE_NAME = "category"
        const val COLUMN_ID = "id"
        const val COLUMN_NAME = "name"
        const val COLUMN_LABELS = "labels"
    }

    override fun equals(other: Any?): Boolean {
        return if (other is Category){
            this.name == other.name && this.labels == other.labels
        }else false
    }
}