package com.flybits.concierge.fragments;


import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.telephony.PhoneNumberUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsViewPopulator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Event;

import java.util.Locale;

public class EventDetailsFragment extends Fragment
{
    private static final String ARG_CONTENT = "flybits_con_param_event";
    private static final int REQUEST_PHONE_CALL = 13;

    private Event event;
    private String contentId;
    private FlybitsViewPopulator flybitsViewPopulator;

    public EventDetailsFragment()
    {
        // Required empty public constructor
    }

    public static EventDetailsFragment newInstance(Event event)
    {
        EventDetailsFragment fragment = new EventDetailsFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_CONTENT, event);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        if (getArguments() != null)
        {
            event = getArguments().getParcelable(ARG_CONTENT);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
    {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.flybits_con_fragment_event_details, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)
    {
        super.onViewCreated(view, savedInstanceState);

        ImageView headerImage = (ImageView) view.findViewById(R.id.flybits_con_fragment_event_details_imgHeader);
        TextView locationView = (TextView) view.findViewById(R.id.flybits_con_fragment_event_details_txtLocation);
        TextView dateView = (TextView) view.findViewById(R.id.flybits_con_fragment_event_details_txtDate);
        TextView callToActionView = (TextView) view.findViewById(R.id.flybits_con_fragment_event_details_txtCallToAction);

        TextView addressView = (TextView) view.findViewById(R.id.flybits_con_fragment_event_details_txtAddress);
        TextView phoneView = (TextView) view.findViewById(R.id.flybits_con_fragment_event_details_txtPhone);
        TextView descriptionView = (TextView) view.findViewById(R.id.flybits_con_fragment_event_details_txtDescription);

        flybitsViewPopulator = new FlybitsViewPopulator(new ContentAnalytics(getContext().getApplicationContext()));
        flybitsViewPopulator.populateEventViews(event,null, null, locationView, dateView, headerImage, null, addressView, callToActionView, phoneView, descriptionView);

        // Phone (need onRequestPermissionResult for callback)
        phoneView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                if (!PhoneNumberUtils.isGlobalPhoneNumber(event.phoneNumber))
                {
                    return;
                }

                if (ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CALL_PHONE) != PackageManager.PERMISSION_GRANTED)
                {
                    requestPermissions(new String[]{Manifest.permission.CALL_PHONE}, REQUEST_PHONE_CALL);
                }
                else
                {
                    makePhoneCall();
                }
            }
        });

        // Open google maps if available.
        addressView.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View v)
            {
                try
                {
                    Uri gmmIntentUri = Uri.parse(String.format(Locale.getDefault(), "geo:0,0?q=%s", event.address));
                    Intent mapIntent = new Intent(Intent.ACTION_VIEW, gmmIntentUri);
                    mapIntent.setPackage("com.google.android.apps.maps");
                    getActivity().startActivity(mapIntent);
                }
                catch (Exception e)
                {
                    Logger.exception(EventDetailsFragment.class.getSimpleName(), e);
                }
            }
        });

    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults)
    {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        switch (requestCode)
        {
            case REQUEST_PHONE_CALL:
            {
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED)
                {
                    makePhoneCall();
                }
                break;
            }
        }
    }

    private void makePhoneCall()
    {
        if (ContextCompat.checkSelfPermission(getActivity(), Manifest.permission.CALL_PHONE) != PackageManager.PERMISSION_GRANTED)
        {
            return;
        }

        Intent intent = new Intent(Intent.ACTION_DIAL); // OR Intent.ACTION_CALL
        intent.setData(Uri.parse(String.format(Locale.getDefault(), "tel:%s", event.phoneNumber)));
        getActivity().startActivity(intent);
    }
}
